function [data,frange,pic,rx,ry,rz,sx,sy,sz,sd,sp,vp,geoazi,geover]=bsegin(fp1,npts,jtrace)
%   |------------------------------------------------------------|
%   | $Id: bsegin.m,v 1.2 2017/05/05 18:48:27 pm Exp $       |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: Octave/Matlab                                    |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: bsegin.m                                    |
%   | DIRECTORY: BSUROOT/Octave                                  |
%   |------------------------------------------------------------|
%   | purpose: read a BSEGY file, data and header information    |
%   |          (direct access of trace=jtrace)                   |
%   |          assumes that the file has been opened             |
%   |          in calling program:  fp1=fopen(filename,'r')      |
%   |------------------------------------------------------------|
%   | Octave is an interpreter useful for scientifc calculations.|
%   |It is similar to MATLAB and Octave files often run in MATLAB|
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
% NOTE:
% total bytes=(240+npts*4)*nt;
% nt=total number of traces to output
% total bytes = total number of bytes in output file
jbyte=(240+npts*4)*(jtrace-1);  %assumes 4 byte floating point data
fseek(fp1,jbyte,'bof');
%header=mget(240,'uc',fp1);   %unsigned character uc
fseek(fp1,40,'cof');

rz=fread(fp1,1,'int32','ieee-le');
sz=fread(fp1,1,'int32','ieee-le');
sd=fread(fp1,1,'int32','ieee-le');
fseek(fp1,16,'cof');
smul1=fread(fp1,1,'int16','ieee-le');
smul2=fread(fp1,1,'int16','ieee-le');
sx=fread(fp1,1,'int32','ieee-le');  %bytes 73-76
sy=fread(fp1,1,'int32','ieee-le');  %bytes 77-80
rx=fread(fp1,1,'int32','ieee-le'); %bytes 81-84
ry=fread(fp1,1,'int32','ieee-le'); %bytes 85-88
fseek(fp1,26,'cof'); % to byte 114
sampno1=fread(fp1,1,'int16','ieee-le'); %bytes 115-116 npts
sampint1=fread(fp1,1,'int16','ieee-le'); %bytes 117-118 sample int in microsec
fseek(fp1,62,'cof');
mst=fread(fp1,1,'int32','ieee-le'); %byte 181-184 first break pic
fseek(fp1,20,'cof');
geoazi=fread(fp1,1,'int16','ieee-le');
geover=fread(fp1,1,'int16','ieee-le');
fseek(fp1,12,'cof');
spc=fread(fp1,4,'char','ieee-le');     %shot point name 4 char
vpc=fread(fp1,4,'char','ieee-le');     %receiver name 4 char
fseek(fp1,12,'cof');    %takes us to byte 240

%...apply scale factors
if smul1 < 0
  sz=sz/abs(smul1);
  sd=sd/abs(smul1);
  rz=rz/abs(smul1);
else
  sz=sz*abs(smul1);
  sd=sd*abs(smul1);
  rz=rz*abs(smul1);
end
if smul2 < 0
  sx=sx/abs(smul2);
  sy=sy/abs(smul2);
  rx=rx/abs(smul2);
  ry=ry/abs(smul2);
else
  sx=sx*abs(smul2);
  sy=sy*abs(smul2);
  rx=rx*abs(smul2);
  ry=ry*abs(smul2);
end
pic=mst/(1.E+06);
frange=sqrt((rx-sx)^2+(ry-sy)^2+(rz-sz)^2);
%read a trace
data=fread(fp1,npts,'float32','ieee-le');  %floating point
% convert character arrays to numbers, labels VP and SP
spa=char(spc);
vpa=char(vpc);
sp=str2double(spa');
vp=str2double(vpa');
end
