//   $Id: A16.ino,v 1.10 2019/04/02 23:00:47 pm Exp $          
/* |------------------------------------------------------------|
   |A16.ino     Seismic Recorder Arduino program                |
   |Author: Dr. P. Michaels, PE <pmsolid@cableone.net>          |
   |or <paulmichaels@boisestate.edu>                            |
   |  NOTICE:                                                   |
   |  Copyright (C) 2019 Paul Michaels                          |
   |  This program is free software; you can                    |
   |  redistribute it and/or modify it under the terms          |
   |  of the GNU General Public License as published            |
   |  by the Free Software Foundation; either version           |
   |  3 of the License, or (at your option) any later           |
   |  version.  This program is distributed in the              |
   |  hope that it will be useful, but                          |
   |  WITHOUT ANY WARRANTY; without even the implied            |
   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
   |  PARTICULAR PURPOSE.  See the GNU General Public           |
   |  License for more details.                                 |
   |  You should have received a copy of the GNU                |
   |  General Public License along with this program;           |
   |  If not, see <https://www.gnu.org/licenses/>               | 
   |------------------------------------------------------------|
 */
// UNIPOLAR VERSION
#include <ExtendedADCShield.h>
#include <SPI.h>

#define nchar 20
#define Nbits 16 
#define Range RANGE5V   /*Set RNG to match Range choice */
#define RNG 5.  // +/- volts
//#define Range RANGE10V   /*Set RNG to match Range choice */
//#define RNG 10.  // +/- volts

//       optimization "s", IDE
//const float slope = 479.0;   // overhead in microseconds
//const float intercept = 393.5;  // slope*k + intercept
//       desktop dell
//       optimization "3", make file
//const float slope = 453.2857; // overhead in microseconds
//const float intercept = 376.7142; // slope*k + intercept
//       opt = 3 blue dell laptop
const float slope = 448.7142;  // overhead in microseconds
const float intercept = 374.2857; // slope*k + intercept
unsigned int shft =0;
int i,j,k;                   // k= number channels
int trig = LOW;
int nsamp;
unsigned int ndt;  //sample interval in microseconds
char buf[nchar];
char nsampbuf[nchar];
char ndtbuf[nchar];
char nchbuf[nchar];
//String S ;          /*dummy string to clear serial for next trigger  */
char ch;



const int ledPin = 13;
const int inputPin = 2;
//const int imax=pow(2,Nbits-1);  // 2^Nbits-1 since bipolar
const unsigned int imax=(unsigned int) pow(2,Nbits);  // 2^Nbits since Unipolar
const float diff = RNG/(float) imax;  // volts/count

//Initialize the ADC Shield with default pins and 16-bit ADC (LTC1858)
ExtendedADCShield extendedADCShield(Nbits);

float ch0;
unsigned int value;
float fcounts;
int armed = 1;
const long DELAY = 1000;
int fieldx;
int parm[3];

// Prototype functions----------------------------------------------------
unsigned int getvalue(int m);
int SampleSendValues(int m);
void sendBinary(unsigned int value);
void sendBinary(long value);

// SETUP------------------------------------------------------------------
void setup() {
  Serial.begin(115200, SERIAL_8N1);
  pinMode(ledPin, OUTPUT);
  pinMode(inputPin, INPUT);
  digitalWrite(inputPin,HIGH);  /*turn on pull up resistor for trigger pin 2
                                trigger by shorting pin 2 to ground  */
  digitalWrite(ledPin,LOW);
  //SPI.begin must be called here on Due only
  SPI.begin();
  //Throw out first read (junk data) and configure input 0 as single ended bipolar -5 to +5V
  extendedADCShield.analogReadConfigNext(0, SINGLE_ENDED, UNIPOLAR, Range);
 // while(ch=Serial.read() >= 0) ; //flush the receive buffer
  Serial.setTimeout(DELAY);
  
} //end setup

// LOOP--------------------------------------------------------------------
void loop() {

      if ( Serial.available() >= (nchar - 1) ) {
	for (fieldx =0; fieldx < 3; fieldx++)
	{
	parm[fieldx] = Serial.parseInt(); //get a parameter
	} //next fieldx
	
	nsamp = parm[0];
	ndt = parm[1];
	k = parm[2];
/*          S= Serial.readString(); 
          S.toCharArray(buf,nchar);          
          for (i=0; i<5; i++) nsampbuf[i]=buf[i];      // 99999 99999 99999   
          for (i=6; i<11; i++) ndtbuf[i-6]=buf[i];    //  5 digits with space between
          for (i=12; i<17; i++) nchbuf[i-12]=buf[i];     
          nsamp = atoi(nsampbuf);
          ndt = atoi(ndtbuf); 
          k = atoi(nchbuf);
*/
            shft = ceil((slope*(float) k ) + intercept); //shft = overhead
            if (ndt > shft) {
            ndt = ndt - shft;  //subtract extra code overhead
            } //endif extra

            Serial.print('H');
           
            
  /*       
          Serial.println(nsamp);
          Serial.println(ndt);
          Serial.println(k);
          Serial.println(shft);
 */
 
          } //end if serial available


              
          i = 0;
          if (armed == 1) {
          trig = digitalRead(inputPin);
          }
         	 if (trig == HIGH)  {
            	digitalWrite(ledPin,LOW); 
          	} else {
            	digitalWrite(ledPin,HIGH);
     //       Serial.flush();
                        
            long int starttime=millis();
 
            armed = SampleSendValues(k);
            
            long duration = millis() - starttime;
            
            
  //          Serial.print('q');              /* send done signal */
            
            sendBinary(duration);  /* send long value  */
	    Serial.flush();
   //        Serial.println(" ");
   //        Serial.print(duration);
   //        Serial.flush();
   //        S = Serial.readString(); 
				       /* clear serial line read into dummy string
                                           and turn off TX, otherwise next trigger
                                           will pick up garbage left in serial line*/

         } //end Trigger loop
         armed = 1;
         trig = HIGH;

}  //endloop

// GETVALUE FUNCTION-----------------------------------------------------------------------
unsigned int getvalue(int kk)
{
  //Read input 0, set up input 0 as bipolar -RNG to RNG Volts (single ended neg goes to ground)
  // bipolar relative to board ground +/-RNG volts
  ch0 =  extendedADCShield.analogReadConfigNext(kk, SINGLE_ENDED, UNIPOLAR, Range); 
  fcounts = ch0/diff;  // fcounts is volts/(volts/count)   
  value = round(fcounts);
  return(value);
}  //end getvalue

// SAMPLE SEND VALUES FUNCTION---------------------------------------------------------------
int SampleSendValues(int k)
{
  int kk;
  for (j=0; j<nsamp; j++) { 
     extendedADCShield.analogReadConfigNext(0, SINGLE_ENDED, UNIPOLAR, Range);
    for (kk = 0; kk<k; kk++) {  
  value = getvalue(kk+1);
   Serial.write(lowByte(value));
   Serial.write(highByte(value));
// Serial.print(lowByte(value));
// Serial.print(" ");
// Serial.print(highByte(value));
// Serial.print(" ");
// Serial.println(value);
    }
//Serial.println(value);
  if (ndt <= 10000)  {
  delayMicroseconds(ndt);                    /* delay ndt microsec.  */
  } else {  
  delay(ndt/1000);                                /*delay msec */
  } //endif
  } //next j
  return(0);
}

// SEND BINARY FUNCTIONS----------------------------------------------------------------------
void sendBinary(int value)
{
 Serial.write(lowByte(value)); //send low byte
 Serial.write(highByte(value)); //send high byte 
}
//-------------------------------------------------------------------------------------------
void sendBinary(long value)
{
  //first send the low 16 bit integer value
  int temp = value & 0xFFFF;  //get value of lower 16 bits
  sendBinary(temp);
  // then send the higher 16 bit integer value:
  temp = value >>16; //get higher 16 bits
  sendBinary(temp);
}
  
