//   $Id: Status.cpp,v 1.1.1.1 2019/03/09 18:39:21 pm Exp $          
/* |------------------------------------------------------------|
   |Status.cpp  Seismic Recorder called by TK Program           |
   |Author: Dr. P. Michaels, PE <pmsolid@cableone.net>          |
   |or <paulmichaels@boisestate.edu>                            |
   |  NOTICE:                                                   |
   |  Copyright (C) 2019 Paul Michaels                          |
   |  This program is free software; you can                    |
   |  redistribute it and/or modify it under the terms          |
   |  of the GNU General Public License as published            |
   |  by the Free Software Foundation; either version           |
   |  3 of the License, or (at your option) any later           |
   |  version.  This program is distributed in the              |
   |  hope that it will be useful, but                          |
   |  WITHOUT ANY WARRANTY; without even the implied            |
   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
   |  PARTICULAR PURPOSE.  See the GNU General Public           |
   |  License for more details.                                 |
   |  You should have received a copy of the GNU                |
   |  General Public License along with this program;           |
   |  If not, see <https://www.gnu.org/licenses/>               | 
   |------------------------------------------------------------|
 */
#include <termios.h>
#include <cstdio>
#include <cstring>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <time.h>

	short debug = 1;
	short serialfd;
	struct termios attribs;
   	char deviceserial[] = "/dev/ttyACM0";
	speed_t speed;
	short usbnumber = 0;

//prototypes
	void  setusb(short usbnumber);

int main () {
	if (access("/dev/ttyACM0",F_OK) != -1 ) {
	sprintf(deviceserial,"/dev/ttyACM0");
	usbnumber = 0;
	puts("Device: ttyACM0"); }


	if (access("/dev/ttyACM1",F_OK) != -1 ) {
	sprintf(deviceserial,"/dev/ttyACM1");
	usbnumber = 1;
	puts("Device: ttyACM1"); }

	if (usbnumber == 0 || usbnumber == 1) {
	serialfd = open(deviceserial,O_RDWR | O_NOCTTY | O_NDELAY);
		if (serialfd == -1) {
		puts("Not Connected");
		return (0);
		//fprintf(stdout,"ABORT failed to open port \n");
		} //endif
	}
	else {
	puts("Device Not found");
	return(0);
	} //endif

/* Set USB */
	setusb(usbnumber);

/* Check that serialfd points to a TTY device */
	if(!isatty(serialfd)) {
	fprintf(stdout,"ABORT, not TTY\n");
	return(0); } //endif

/* get the current settings */
	if(tcgetattr(serialfd, &attribs) < 0) {
	fprintf(stdout,"ABORT, can not get configuration\n");
	return(0);} //endif


if(debug !=0 ) {
	speed = cfgetispeed(&attribs);
	if (speed == 4098) puts("BAUD: 115200");
//	fprintf(stdout,"input speed: %lu\n", (unsigned long) speed);
//	speed = cfgetospeed(&attribs);
//	fprintf(stdout,"output speed: %lu\n", (unsigned long) speed);
//	puts("---------------\n");
	} //endif

  return(0);
} //endmain

void  setusb(short usbnumber) {
char command0[] = "stty -F /dev/ttyACM0 -parenb -parodd -cmspar cs8 115200 \
  -hupcl -cstopb cread clocal -crtscts \
-ignbrk brkint ignpar -parmrk -inpck -istrip -inlcr -igncr -icrnl ixon -ixoff \
-iuclc -ixany -imaxbel -iutf8 \
-opost -olcuc -ocrnl -onlcr -onocr -onlret -ofill -ofdel nl0 cr0 tab0 bs0 vt0 ff0 \
-isig -icanon iexten -echo echoe echok -echonl -noflsh -xcase -tostop -echoprt \
echoctl echoke -flusho -extproc";
char command1[] = "stty -F /dev/ttyACM1 -parenb -parodd -cmspar cs8 115200 \
  -hupcl -cstopb cread clocal -crtscts \
-ignbrk brkint ignpar -parmrk -inpck -istrip -inlcr -igncr -icrnl ixon -ixoff \
-iuclc -ixany -imaxbel -iutf8 \
-opost -olcuc -ocrnl -onlcr -onocr -onlret -ofill -ofdel nl0 cr0 tab0 bs0 vt0 ff0 \
-isig -icanon iexten -echo echoe echok -echonl -noflsh -xcase -tostop -echoprt \
echoctl echoke -flusho -extproc";
	if (usbnumber == 0) {
	system(command0);}
	else {
	system(command1);}
} //endsetusb
