//This example shows how to use the Extended ADC Shield for a variety of analog inputs

#include <ExtendedADCShield.h>
#include <SPI.h>

//Initialize the ADC Shield with default pins and 14-bit ADC (LTC1858)
ExtendedADCShield extendedADCShield(14);

float ch0, ch1m0;


void setup() {
  Serial.begin(115200);
  //SPI.begin must be called here on Due only
  SPI.begin();
  //Throw out first read (junk data) and configure input 0 as single ended bipolar -5 to +5V
  extendedADCShield.analogReadConfigNext(0, SINGLE_ENDED, BIPOLAR, RANGE10V);
}


void loop() {
  //Read input 0, set up input 0 and 1 ass differential (input 1 minus input 0) bipolar 0 to 10V
  ch0 =  extendedADCShield.analogReadConfigNext(1, DIFFERENTIAL, BIPOLAR, RANGE10V);
  
  //Read input 1 minus 0, set up input 0 as single ended bipolar -5 to +5V
  ch1m0 =  extendedADCShield.analogReadConfigNext(0, SINGLE_ENDED, BIPOLAR, RANGE10V);
    
  //Print results with 10 decimal places of precision
//  Serial.print(ch0,10);  
//  Serial.print("\t"); 
  Serial.print(ch1m0,10);  
  Serial.print("\n"); 
  delay(1000);
}  
  
