//test study of integer types
// compile: gcc -Wall -lm -o tst tst.c
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#define Nbits 16
#define RNG 10.0

//Prototypes
	unsigned char lowByte(short ivalue);
	unsigned char highByte(short ivalue);

   int main(int argc, char *argv[]) {
	unsigned char Lbyte;
	unsigned char Hbyte;
	short ivalue;
	int intval;
	const int imax = floor(pow((double)2.,(double)(Nbits-1)));
        const float diff = RNG/(float)imax;  //volts/count
	float fvalue;
	float mvolts;
	int microvolts;

	fvalue = 5.50;
	intval = roundf(fvalue / diff);
	ivalue = (short) intval;
	fprintf(stdout,"intval = %d  %0x \n",intval,intval);
	fprintf(stdout,"ivalue = %d  %0x \n",ivalue,ivalue);
	fprintf(stdout,"fvalue = %f \n", (float)intval*diff);	

	Lbyte = lowByte(ivalue);
	Hbyte = highByte(ivalue);
	fprintf(stdout,"Lbyte = %0x  Hbyte = %0x  \n",Lbyte,Hbyte);
	ivalue = Hbyte*256 + Lbyte;
	fprintf(stdout," imax = %d  diff = %E \n",imax,diff);
	fprintf(stdout," ivalue = %d \n",ivalue); 
	mvolts = ((float)(ivalue) * diff)*1000.0;
	microvolts = floor( (mvolts * 1000.0 +.5)) ;
	fprintf(stdout," mvolts = %f microvolts = %d \n",mvolts,microvolts);


	return (0);
   } //endmain

//FUNCTIONS
	unsigned char lowByte(short ivalue)
	{
	short mask = 0xff;
	return (mask & ivalue);
	}
	unsigned char highByte(short ivalue)
	{
	short mask = 0xff;
	return (mask & (ivalue >> 8) );
	}

