%    $Id: Dispcurve.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $          

%compute dispersion curve from Vibroseis Spectra (file 20mSourceOffset.mat)
%Reference:
% Michaels, P., (2014), ''Alternatives in Analysis of the UTexas1 Surface Wave Dataset'' in Geo-Congress 2014,
% Technical Papers and Keynote Lectures, Edited by Anand J. Puppala, Ph.D., P.E., D.GE.; 
%Paola Bandini, Ph.D., P.E.; Thomas C. Sheahan, Sc.D., P.E.; Murad Abu-Farsakh, Ph.D., P.E.; 
%Xiong Yu, Ph.D., P.E.; and Laureano R. Hoyos, Ph.D., P.E, GSP 234-235 , p. 761-772,
% ISBN: 9780784413296 
% Data Set:
% See file UTexas1VibroseisData.txt for description of 20mSourceOffset.mat

%EXAMPLE CODE
%This program shows how to compute a dispersion curve from pairs of receivers which recorded
% constant frequency tests (91 frequencies, 21 receivers)
% at each frequency, phase difference between adjacent stations is computed, unwrapped, and
% then used to compute a time shift between stations, "dt". The ratio of the station separations
% to time shift gives phase velocity for that frequency.  
% Consistent phase velocity results for many pairs supports a valid result.  Scatter in phase
% velocity supports an interpretation of insufficient radiation recorded at that frequency.

clear 
load 20mSourceOffset.mat;
clf
[nfreq,ntraces]=size(Data);
F=flipud(Frequency);
RX=0:10:200;
SX=ones(1,21)*(-20);
X=RX-SX;

k=1;
for jtr=2:1:ntraces
tr2=jtr;
tr1=tr2-1;
S1=flipud(Data(:,tr1));
S2=flipud(Data(:,tr2));
DS=S2.*conj(S1);
dph=unwrap(angle(DS));
mag=abs(DS);
dx=X(tr2)-X(tr1);
dt=(dph./F)./(2*pi);
cvel=abs(dx./dt);
SVcvel(:,k)=cvel;
mxmag=max(mag);
SVmag(:,k)=mag./mxmag;
k=k+1;

subplot(211)
plot(F,cvel,'+')
  if jtr==2
   g1=gca;
   set(g1,'ylim',[0,1000]);
   hold on
   %xlabel('Frequency (Hz)');
   ylabel('Phase Velocity (m/s)');
   TT=sprintf('Vibroseis: Src=%.0f Offsets: %.0f to %.0f meters',SX(1),X(1),X(ntraces));
   title(TT)
   grid
  end
subplot(212)
plot(F,mag./mxmag)
  if jtr==2
   hold on
   xlabel('Frequency (Hz)');
   ylabel('Normalized Amplitude');
   title('Power Cross Spectra');
   grid
  end
end
hold off
print('plotdisp.ps','-dpsc2');

[nr,nestm]=size(SVcvel);
%save data to file
fid=fopen('dispdata.txt','w');
  for j=1:nfreq
    fprintf(fid,' %.14E ',F(j),SVcvel(j,1:nestm));
    fprintf(fid,' \n');
  end %next j
fclose(fid);
%save data to file
fid=fopen('spectdata.txt','w');
  for j=1:nfreq
    fprintf(fid,' %.14E ',F(j),SVmag(j,1:nestm));
    fprintf(fid,' \n');
  end %next j
fclose(fid);

CVm=mean(SVcvel,2);
erb=std(SVcvel,0,2);
SMm=mean(SVmag,2);
erbm=std(SVmag,0,2);
%errorbar(F,CVm,erb);
%save data to file (mean and std)
fid=fopen('CMstddata.txt','w');
  for j=1:nfreq
    fprintf(fid,' %.14E ',F(j),CVm(j),erb(j));
    fprintf(fid,' \n');
  end %next j
fclose(fid);
fid=fopen('CMagstddata.txt','w');
  for j=1:nfreq
    fprintf(fid,' %.14E ',F(j),SMm(j),erbm(j));
    fprintf(fid,' \n');
  end %next j
fclose(fid);






