%    $Id: PseudoTime.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $          
%Reference:
% Michaels, P., (2014), ''Alternatives in Analysis of the UTexas1 Surface Wave Dataset'' in Geo-Congress 2014,
% Technical Papers and Keynote Lectures, Edited by Anand J. Puppala, Ph.D., P.E., D.GE.; 
%Paola Bandini, Ph.D., P.E.; Thomas C. Sheahan, Sc.D., P.E.; Murad Abu-Farsakh, Ph.D., P.E.; 
%Xiong Yu, Ph.D., P.E.; and Laureano R. Hoyos, Ph.D., P.E, GSP 234-235 , p. 761-772,
% ISBN: 9780784413296 
% Data Set:
% See file UTexas1VibroseisData.txt for description of 20mSourceOffset.mat

%EXAMPLE CODE
%compute time domain PSEUDO SIGNALS dt=1/25.6 seconds 
% these are not the time recordings, but rather the result
% of taking the spectra, padding with zeros and reflecting
% the positive frequencies with the conjugate for negative 
% frequencies, then taking the inverse FFT.
% Author: P. Michaels, PE  <pm@cgiss.boisestate.edu>
% Data from B. Cox, UT Christchurch NZ
% version 2 Wed Apr 10 13:33:01 MDT 2013

clear 
% load signal processing tool kit
pkg load signal

load 20mSourceOffset.mat;
  % variables Data=spectra recorded (91x21), Frequency=discrete spectral frequencies (91x1)
  dt=.004; %desired time sample interval
  df=0.10000;  %frequency interval

% Type of normalization?
nc=questdlg('Choose Normalization','Plot Scaling','Trace','Prof.','Trace')
switch nc
  case {'Trace'}
  ntype=1;
  case {'Prof.'}
  ntype=2;
end

clf
figure(1)
RX=0:10:200;
SX=ones(1,21)*(-20);
X=RX-SX;
%tr=[1,5];
tr=1:21;
ntraces=length(tr);
for kk=1:ntraces
tr1=tr(kk);
S1=flipud(Data(:,tr1)); %form column vector for selected signal
npts=length(S1);
  nsamp=1/(df*dt);  %sample total length when ready for ifft (dt=desired time sample int.)
  fnyq=floor(1/(2*dt));  % Nyquist frequency
  NF=length(Frequency);
  fmn=min(Frequency);
  jmin=fmn/df;
  F(jmin+1:NF+jmin)=flipud(Frequency); % now F =0, 0, 0, ... 1.0, 1.1, 1.2, ....10.0
  S1(jmin+1:NF+jmin)=flipud(Data(:,tr1));
  jnyq=fnyq/df+1;
F(1:jmin)=0:.1:.9;  % now F =0, .1, ... 1.0, 1.1, 1.2, ....10.0
S1(1:jmin)=complex(zeros(1,jmin));
F(NF+jmin+1:jnyq)=F(NF+jmin)+df:.1:fnyq;
S1(NF+jmin+1:jnyq)=complex(zeros(size(NF+jmin+1:jnyq))');
F(jnyq+1:nsamp)=fnyq+df:.1:(2*fnyq-df);
  k=2;
  %mirror rest of spectrum
    for j=nsamp:-1:jnyq+1
    S1(j)=conj(S1(k));
    k=k+1;
    end
  s=ifft(S1);
%  ntype=1;
 if ntype == 2
% profile normalization, relative trace amplitudes preserved 
  if kk == 1
  sfact=max(real(s));
  end
 else
% trace normalization, each trace scaled to 1
  sfact=max(real(s));
 end
  ss(:,kk)=real(s)./sfact;   %normalized version
  N=length(s);
    for j=1:N
    tm(j)=(j-1)*dt;
    end
  if kk == 1
  plot(tm,ss(:,1))
  hold on
  else
  plot(tm,ss(:,kk)-(kk-1)*1.5)
  end
end

xlabel('Time (s)');
grid
hold off
title('PSEUDO Signals from Spectra (10:-.1:1.0 Hz)  Christchurch NZ Vibroseis')
skip=1;
if skip == 0
 %cross correlation
 a=xcorr(ss(:,2)',ss(:,1)');
 figure(2)
 NA=length(a);
 NA2=NA/2;
 lags=-NA2:1:NA2-1;
 plot(lags*dt,a);
 xlabel('Time (s)');
 title('Cross Correlation')
 grid
 end
%output data in text
fid=fopen('data.txt','w')
 for j=1:N
  fprintf(fid,' %.14E ',ss(j,1:ntraces));
  fprintf(fid,' \n');
 end %next j
fclose(fid);

