function [flag]=bsegout(fp1,npts,jtrace,nt,data,dx,dt,pic,...
rx,ry,rz,sx,sy,sz,sd,sp,vp,geoazi,geover)
%   |------------------------------------------------------------|
%   | $Id: bsegout.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $          |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: Octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: bsegout.m                                   |
%   | DIRECTORY: BSUROOT/Octave                                  |
%   |------------------------------------------------------------|
%   | purpose: write a BSEGY file, data and header information   |
%   |          (direct access of trace=jtrace)                   |
%   |          assumes that the file has been opened for binary  |
%   |       fp1=fopen(fileout,'w')                               |
%   |                                                            |
%   |------------------------------------------------------------|
%   | Octave is similar to MATLAB and may be obtained free       |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
% NOTE:
% total bytes=(240+npts*4)*nt;
% nt=total number of traces to output
% total bytes = total number of bytes in output file
headplustr=240+npts*4;
% skip to trace jtrace and clear
jbyte=(headplustr)*(jtrace-1);  %assumes 4 byte floating point data
for j=1:headplustr ; b=fwrite(fp1,0,'uchar'); end

%if (icall == 0 )
% %zero out file
% for j=1:tbytes; b=fwrite(fp1,0,'uchar'); end
%end

%set sample interval to microseconds
fsamin=dt*1E+6;

%set scalar multipliers
      smul1=1;
      smul2=1;
      if(abs(dx)<100.0) 
      smul1=-10;
      smul2=-10;
      end
      if(abs(dx)<10.0) 
      smul1=-100;
      smul2=-100;
      end
      if(abs(dx)<1.0) 
      smul1=-1000;
      smul2=-1000;
      end
%...apply scale factors
if smul1 < 0
  sz=sz*abs(smul1);
  sd=sd*abs(smul1);
  rz=rz*abs(smul1);
else
  sz=sz/abs(smul1);
  sd=sd/abs(smul1);
  rz=rz/abs(smul1);
end
if smul2 < 0
  sx=sx*abs(smul2);
  sy=sy*abs(smul2);
  rx=rx*abs(smul2);
  ry=ry*abs(smul2);
else
  sx=sx/abs(smul2);
  sy=sy/abs(smul2);
  rx=rx/abs(smul2);
  ry=ry/abs(smul2);
end
%pic=mst*(1.E+06);

% skip to trace jtrace
jbyte=(240+npts*4)*(jtrace-1);  %assumes 4 byte floating point data
fseek(fp1,jbyte,'bof');
bout=0;
for j=1:40; b=fwrite(fp1,0,'uchar'); bout=bout+b; end
%fseek(fp1,40,'cof');
b=fwrite(fp1,rz,'int32');
bout=bout+b;
b=fwrite(fp1,sz,'int32');
bout=bout+b;
b=fwrite(fp1,sd,'int32');
bout=bout+b;
for j=1:16; fwrite(fp1,0,'uchar');bout=bout+b; end
%fseek(fp1,16,'cof');
b=fwrite(fp1,smul1,'int16');
bout=bout+b;
b=fwrite(fp1,smul2,'int16');
bout=bout+b;
b=fwrite(fp1,sx,'int32');  %bytes 73-76
bout=bout+b;
b=fwrite(fp1,sy,'int32');  %bytes 77-80
bout=bout+b;
b=fwrite(fp1,rx,'int32');  %bytes 81-84
bout=bout+b;
b=fwrite(fp1,ry,'int32');  %bytes 85-88
bout=bout+b;
for j=1:26; fwrite(fp1,0,'uchar');bout=bout+b; end
%fseek(fp1,26,'cof');
b=fwrite(fp1,npts,'int16');  %bytes 115-116 npts
bout=bout+b;
b=fwrite(fp1,fsamin,'int16');  %bytes 117-118 sample int in microsec
bout=bout+b;
for j=1:62; b=fwrite(fp1,0,'uchar');bout=bout+b; end
%fseek(fp1,62,'cof');
mst=pic*1E+6;
b=fwrite(fp1,mst,'int32');  %byte 181-184 first break pic
bout=bout+b;
for j=1:20; b=fwrite(fp1,0,'uchar');bout=bout+b; end
%fseek(fp1,20,'cof');
b=fwrite(fp1,geoazi,'int16');
bout=bout+b;
b=fwrite(fp1,geover,'int16');
bout=bout+b;
fseek(fp1,12,'cof');
b=fwrite(fp1,sp,'char');   %shot point name 4 char
bout=bout+b;
b=fwrite(fp1,vp,'char');   %receiver name 4 char
bout=bout+b;
for j=1:12; b=fwrite(fp1,0,'uchar');bout=bout+b; end
%fseek(fp1,12,'cof');    %takes us to byte 240
%read a trace
fseek(fp1,jbyte+240,'bof');
flag=fwrite(fp1,data,'float32'); %floating point
end     

