%   |------------------------------------------------------------|
%   | $Id: cafwd3.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $           |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: caplot3                                     |
%   | DIRECTORY: BSUROOT/Octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose: performs the forward problem Kelvin solid,        |
%   |          manually choose C1 and C2, plots against a        |
%   |          bvas.his and bamp.his files of measured data.     |
%   |          (bvas.his=dispersion, bamp.his=decay vs freq.)    |
%   |          C1=stiffness m^2/s^2                              |
%   |          C2=damping  m^2/s                                 |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
%Function Definitions
function [rt,sigmart]=relaxtime(c1,sigma1,c2,sigma2)
% compute relaxation time, sigma's are 1 stdev
rt=c2/c1;
sigmart=sqrt( ((c2/(c1*c1))*sigma1)^2 + ((1.0/c1)*sigma2)^2);
end
nc=questdlg('Stiffness and Damping','Choose','With Data','Without Data','With Data');
switch nc
  case {'With Data'}
  isw2=1;
  fnambtxt=sprintf('bvas.his');
  fnamatxt=sprintf('bamp.his');
  case {'Without Data'}
  isw2=0;
end

if isw2 == 1
sw1=exist('bvas.his', 'file');
sw2=exist('bamp.his', 'file');
  if sw1==0 || sw2 == 0
disp('-----------------------------------------');
disp('==>NOTE: bvas.his and bamp.his required');
disp('-----------------------------------------');
end
end
% if no data
if isw2==0 
fmin=10;
fmax=200;
df=2;
fb=fmin:df:fmax ;  % define frequency range
fa=fb;
nfa=length(fa);
nfb=nfa;
end

if isw2 == 1
ampl=load('-ascii',fnamatxt);
bvas=load('-ascii',fnambtxt);
sembl=bvas(:,4);
fcc=bvas(:,1);
v=bvas(:,2);
vp=bvas(:,3);
vm=bvas(:,3);
faa=ampl(:,1);
a=ampl(:,2);
ap=ampl(:,3);
am=ampl(:,3);
xmax=max([max(fcc),max(faa)]);
ymax=max(v);
xmin=min([min(fcc),min(faa)]);
ymin=min(v);
figure(1)
clf
subplot(3,1,1)
% frequency vs velocity 
errorbar(fcc,v,vm,vp,'<.');
axis([0,xmax,ymin,ymax]);
grid on
ylabel('Velocity m/s');
title('Data: bvas.his and bamp.his ')
subplot(3,1,2)
% frequency vs attenuation
errorbar(faa,a,am,ap,'<.');
ymin=min(a);
ymax=max(a);
axis([0,xmax,0,ymax]);
ylabel('Decay 1/m ');
grid on
subplot(3,1,3)
% frequency vs Semblance
ymin=min(sembl);
ymax=max(sembl);
plot(fcc,sembl,'-r');
axis([0,xmax,0,1]);
grid on
ylabel('Semblance');
xlabel('Frequency Hz');
drawnow
coulmb=0;
coulsw=0;
if coulsw==1 

end

msgbox('Use mouse to pick min and max frequencies');
%...get min and max frequencies with mouse;
[xl,yl]=ginput(2);
fmin=min(xl);
fmax=max(xl);

xyb=size(bvas);
jjf=0;
jjfx=0;
for jf=1:xyb(1)
  if bvas(jf,1)>fmin 
  if bvas(jf,1)<fmax
    jjf=jjf+1;
    fb(jjf,1)=bvas(jf,1);
    c(jjf,1)=bvas(jf,2);
    erb(jjf,1)=bvas(jf,3)^2;  %var;
    stdvb(jjf,1)=bvas(jf,3);  %stdv for 68 percent confidence;
  end;
  end;
% excluded data
  if bvas(jf,1)<fmin ||  bvas(jf,1)>fmax
    jjfx=jjfx+1;
    fbx(jjfx,1)=bvas(jf,1);
    cx(jjfx,1)=bvas(jf,2);
    stdvbx(jjfx,1)=bvas(jf,3);  % stdv for 68 percent confidence;
    ccalx(jjfx,1)=0.0;
  end;
end; %next jf

xya=size(ampl);
jjfa=0;
jjfax=0;
for jf=1:xya(1)
  if ampl(jf,1)>fmin 
  if ampl(jf,1)<fmax
    jjfa=jjfa+1;
    fa(jjfa,1)=ampl(jf,1);
% ...Convert from dB/m to 1/m;
%     alpha(jjfa,1)=-ampl(jf,2)/8.686;
     alpha(jjfa,1)=ampl(jf,2)-coulmb;
%     era(jjfa,1)=(ampl(jf,3)/8.686)^2;
     era(jjfa,1)=(ampl(jf,3))^2; % variance;
     stdva(jjfa,1)=ampl(jf,3); % std for 68 percent confidence;
  end;
  end;
% excluded data
  if ampl(jf,1)<fmin || ampl(jf,1)>fmax 
    jjfax=jjfax+1;
    fax(jjfax,1)=ampl(jf,1);
     alphax(jjfax,1)=ampl(jf,2)-coulmb;
     stdvax(jjfax,1)=ampl(jf,3); % std for 68 percent confidence;
     acalx(jjfax,1)=0.0;
  end;
end;  % next jf
% clear graphics window
close;  %close figure
%...mean data variances
mera=0;
merb=0;
npts=jjf;
nptsa=jjfa;
for j=1:npts
merb=merb+erb(j);
end;
for j=1:nptsa
mera=mera+era(j);
end;
mera=mera/nptsa;
merb=merb/npts;
nfb=length(fb);
nfa=length(fa);

% c1=min(c)^2;
% c2=10;
[amxm,ka]=max(a);
fmxm=fcc(ka);
cmxm=v(ka);
wmxm=2*pi*fmxm;
betamxm=wmxm/cmxm;
dmxm=(betamxm^2+amxm^2)^2;
c1=((betamxm^2-amxm^2)*(wmxm^2))/dmxm;
c2=(2*amxm*betamxm*wmxm)/dmxm;
 %  isw2 data/ no data
else
 % generic first guess when no data
c1=100*100;    % stiffness m^2/s^2
c2=5;          % damping m^2/s
end % endif isw2 == 1


% begin loop
isw1=1;
while isw1 == 1
%set initial parameters
prompt = {'C1','C2'};
dlg_title = 'Set initial Parameters';
num_lines = 1;
defaultans = {num2str(c1),num2str(c2)};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
if size(cn) == 0
break;
else
RSLT = str2double(cn);
c1=RSLT(1);
c2=RSLT(2);
end

% ...loop on BVAS frequency
for jf=1:nfb
w=2*pi*fb(jf);
D=sqrt((w*c2)^2+c1^2);
ccal(jf,1)=((D^2+c1*D)*sqrt(2))/( (c1+D)^(1.5) );
%...delta data;
  if isw2==1 
  deldataC(jf,1)=c(jf)-ccal(jf);
  end    
end;
%-----------end BVAS frequency loop
%...loop on AMPL frequency
for jf=1:nfa
jblock=jf+nfb;
w=2*pi*fa(jf);
D=sqrt((w*c2)^2+c1^2);
b=2*(c1+D);
acal(jf,1)=(4*sqrt(b)*w^2*c2)/((2*w*c2)^2+b^2);
%...delta data;
  if isw2==1 
  deldataA(jblock,1)=alpha(jf)-acal(jf);
  end
end;
%-----------end AMPL frequency loop 
%...fit error;
  if isw2==1 
  LSQC=sqrt(deldataC'*deldataC)/mean(c);
  LSQA=sqrt(deldataA'*deldataA)/mean(alpha);
  LSQ=LSQC+LSQA;
  else
  LSQ=0;
  end

figure(1)
clf
%..plot intermediate results;
xmax=max(fb);
 if isw2==1 
 ymax1(1)=max(c);
 else
 ymax1(1)=0;
 end
ymax1(2)=max(ccal);
ymax=max(ymax1);
xmin=0;
ymin=0;
subplot(2,1,1);
plot(fb,ccal,'-r');
axis([xmin,xmax,ymin,ymax]);
grid on
% if data
 if isw2==1
 hold on
 errorbar(fb,c,stdvb,stdvb,'<.');
 end
 relaxtm=(c2/c1)*1000;
 rttxt=sprintf('Relaxation Time=%.3f ms',relaxtm);
 if isw2==1 
 T=sprintf('Velocity %s C1=%f C2=%f Lsqe=%1.3e',rttxt,c1,c2,LSQ);
 title(T);
 else
 T=sprintf('Velocity %s C1=%f C2=%f ',rttxt,c1,c2);
 title(T);
 end
subplot(2,1,2)
 if isw2==1  
 ymax1(1)=max(alpha);
 else
 ymax1(1)=0;
 end
ymax1(2)=max(acal);
ymax=max(ymax1);
plot(fa,acal,'-r');
axis([0,xmax,ymin,ymax]);
grid on
 if isw2==1 
 hold on
 errorbar(fa,alpha,stdva,stdva,'<.');
 end
title('Attenuation');
xlabel('Frequency Hz');
ylabel(' (1/m)');
drawnow 

figure(2)
clf

% compute Q
N=min(nfa,nfb);
for j=1:N
Q(j,1)=(pi*fa(j))/(acal(j)*ccal(j));
if isw2==1
Qd(j,1)=(pi*fb(j))/(alpha(j)*c(j));
ap=alpha(j)+stdva(j);
Qp=(pi*fb(j))/(ap*c(j));
am=alpha(j)-stdva(j);
Qm=(pi*fb(j))/(am*c(j));
stdvQd(j,1)=(Qp-Qm)/2;
end
end
ymax1(2)=max(ccal);
ymax=max(ymax1);
xmin=0;
ymin=0;
subplot(2,1,1);
plot(fb,ccal,'-r');
axis([xmin,xmax,ymin,ymax]);
grid on
% if data
 if isw2==1
 hold on
 errorbar(fb,c,stdvb,stdvb,'<.');
 end
 relaxtm=(c2/c1)*1000;
 rttxt=sprintf('Relaxation Time=%.3f ms',relaxtm);
 if isw2==1 
 T=sprintf('Velocity %s C1=%f C2=%f Lsqe=%1.3e',rttxt,c1,c2,LSQ);
 title(T);
 else
 T=sprintf('Velocity %s C1=%f C2=%f ',rttxt,c1,c2);
 title(T);
 end
subplot(212)
xmin=0;
ymin=.1;
xmax=max(fa);
ymax=max(Q);
%semilogy(fb,Q,'-r')
plot(fb(1:N),Q,'-r')
if isw2 == 1
hold on
%plot(fb(1:N),Qd,'o')
errorbar(fb(1:N),Qd,stdvQd,stdvQd,'<.');
end
axis([xmin,xmax,ymin,ymax]);
grid on
title('Quality Factor, Q');
xlabel('Frequency Hz');
ylabel('unitless');
drawnow 


end % endwhile loop
