%   |------------------------------------------------------------|
%   | $Id: cainv3.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $           |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: cainv3                                      |
%   | DIRECTORY: BSUROOT/Octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   |                                                            |
%   | purpose: performs the joint inversion of dispersion and    |
%   |          decay observed on a direct wave in a down-hole    |
%   |          survey.  Assumes a Kelvin solid.  One uses a GUI  |
%   |          to select the frequencies for analysis.           |
%   |          Output includes C1 and C2 (stiffness and damping) |
%   |          (bvas.his=dispersion, bamp.his=decay vs freq.)    |
%   |          C1=stiffness m^2/s^2                              |
%   |          C2=damping  m^2/s                                 |
%   |  Use caplot3.m   to make a nice plot of the results        |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear

%Function Definitions
function [rt,sigmart]=relaxtime(c1,sigma1,c2,sigma2)
% compute relaxation time, sigma's are 1 stdev
rt=c2/c1;
sigmart=sqrt( ((c2/(c1*c1))*sigma1)^2 + ((1.0/c1)*sigma2)^2);
end

fnamb='bvas.his';
fnama='bamp.his';

fp1=fopen(fnama,'r');
fp2=fopen(fnamb,'r');

ampl=load('-ascii',fnama);
bvas=load('-ascii',fnamb);
fclose(fp1);
fclose(fp2);

%define vectors
sembl=bvas(:,4);
fcc=bvas(:,1);
v=bvas(:,2);
vp=bvas(:,3);
vm=bvas(:,3);
faa=ampl(:,1);
a=ampl(:,2);
ap=ampl(:,3);
am=ampl(:,3);
xmax=max([max(fcc),max(faa)]);
ymax=max(v);
xmin=min([min(fcc),min(faa)]);
ymin=min(v);
frect=[xmin,ymin,xmax,ymax];

%plot data
subplot(3,1,1)
% avoid clip, and xfig out of bounds
for j=1:length(v)
if v(j)+vp(j) > max(v) 
 vp(j)=max(v)-v(j); end;
if v(j)-vm(j) < min(v) 
 vm(j)=v(j)-min(v); end;
end;  %next j
errorbar(fcc,v,vm,vp,'o')
title('Velocity')
grid on

subplot(3,1,2)
ymin=min(a);
ymax=max(a);
frect=[xmin,ymin,xmax,ymax];
errorbar(faa,a,am,ap,'o')
grid on
title('Attenuation');

subplot(3,1,3)
ymin=min(sembl);
ymax=max(sembl);
frect=[xmin,ymin,xmax,ymax];
plot(fcc,sembl,'-r')
grid on
title('Semblance');
xlabel('Frequency (Hz)');

% restore error bars
vp=bvas(:,3);
vm=bvas(:,3);
ap=ampl(:,3);
am=ampl(:,3);

coulmb=0;
coulsw=0;
if coulsw==1 

end
drawnow
msgbox('Use mouse to pick min and max frequencies');
%...get min and max frequencies with mouse;
[xl,yl]=ginput(2);
fmin=min(xl);
fmax=max(xl);

xyb=size(bvas);
jjf=0;
jjfx=0;
for jf=1:xyb(1)
  if bvas(jf,1)>fmin 
  if bvas(jf,1)<fmax
    jjf=jjf+1;
    fb(jjf,1)=bvas(jf,1);
    c(jjf,1)=bvas(jf,2);
    erb(jjf,1)=bvas(jf,3)^2;  %var;
    stdvb(jjf,1)=bvas(jf,3);  %stdv for 68 percent confidence;
  end;
  end;
% excluded data
  if bvas(jf,1)<fmin ||  bvas(jf,1)>fmax
    jjfx=jjfx+1;
    fbx(jjfx,1)=bvas(jf,1);
    cx(jjfx,1)=bvas(jf,2);
    stdvbx(jjfx,1)=bvas(jf,3);  % stdv for 68 percent confidence;
    ccalx(jjfx,1)=0.0;
  end;
end; %next jf

xya=size(ampl);
jjfa=0;
jjfax=0;
for jf=1:xya(1)
  if ampl(jf,1)>fmin 
  if ampl(jf,1)<fmax
    jjfa=jjfa+1;
    fa(jjfa,1)=ampl(jf,1);
% ...Convert from dB/m to 1/m;
%     alpha(jjfa,1)=-ampl(jf,2)/8.686;
     alpha(jjfa,1)=ampl(jf,2)-coulmb;
%     era(jjfa,1)=(ampl(jf,3)/8.686)^2;
     era(jjfa,1)=(ampl(jf,3))^2; % variance;
     stdva(jjfa,1)=ampl(jf,3); % std for 68 percent confidence;
  end;
  end;
% excluded data
  if ampl(jf,1)<fmin || ampl(jf,1)>fmax 
    jjfax=jjfax+1;
    fax(jjfax,1)=ampl(jf,1);
     alphax(jjfax,1)=ampl(jf,2)-coulmb;
     stdvax(jjfax,1)=ampl(jf,3); % std for 68 percent confidence;
     acalx(jjfax,1)=0.0;
  end;
end;  % next jf
% clear graphics window
close;  %close figure

%...mean data variances
mera=0;
merb=0;
npts=jjf;
nptsa=jjfa;
for j=1:npts
merb=merb+erb(j);
end;
for j=1:nptsa
mera=mera+era(j);
end;
mera=mera/nptsa;
merb=merb/npts;
nfb=length(fb);
nfa=length(fa);
%...damping matrix;
damp=0;
%damp=input('Enter dampening coef: ');
dwm=[1,0;0,1];
dwm=dwm*damp;

%...initial guess;
[amxm,ka]=max(alpha);
fmxm=fa(ka);
[cmxm,kb]=max(c);
wmxm=2*pi*fmxm;
betamxm=wmxm/cmxm;
dmxm=(betamxm^2+amxm^2)^2;
c1first=((betamxm^2-amxm^2)*(wmxm^2))/dmxm;
c2first=(2*amxm*betamxm*wmxm)/dmxm;

c1firstxt=sprintf('%8.0f',c1first);
c2firstxt=sprintf('%8.0f',c2first);
nitertxt=sprintf('10');

%set initial parameters
prompt = {'C1','C2','Number Iterations'};
dlg_title = 'Set initial Parameters';
num_lines = 1;
defaultans = {c1firstxt,c2firstxt,nitertxt};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
RSLT = str2double(cn);
c1=RSLT(1);
c2=RSLT(2);
niter=RSLT(3);

%set weighting based on data confidence
nc=questdlg('Choose Weighting','ROW Weighting','1/var','1/stdv','none','none')
switch nc
  case {'1/var'}
  weight=2;
  Wtxt='1/var';
  case {'1/stdv'}
  weight=1;
  Wtxt='1/stdv';
  case {'none'}
  weight=0;
  Wtxt='none';
end  %endswitch

%set balance velocity/decay block weighting
prompt = {'BALANCE: Velocity/Decay (0.5 is Equal)'};
dlg_title = 'Set Block Weighing: Velocity to Decay';
num_lines = 1;
defaultans = {'0.5'};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
balance = str2double(cn);

% ...loop on interation;
for iter=1:niter
% ...loop on BVAS frequency
for jf=1:nfb
w=2*pi*fb(jf);
D=sqrt((w*c2)^2+c1^2);
ccal(jf,1)=((D^2+c1*D)*sqrt(2))/( (c1+D)^(1.5) );
denom1=( ((c1+D)^(5/2))*D );
% ...dcdc1;
G(jf,1)=-sqrt(2)*(-c1^2*D-c1^3+0.5*D*w^2*c2^2)/denom1;
% ...dcdc2;
G(jf,2)=0.5*w^2*c2*sqrt(2)*(3*c1*D+w^2*c2^2+3*c1^2)/denom1;
% ...delta data;
deldata(jf,1)=c(jf)-ccal(jf);    
end;
% -----------end BVAS frequency loop
% ...loop on AMPL frequency
for jf=1:nfa
jblock=jf+nfb;
w=2*pi*fa(jf);
D=sqrt((w*c2)^2+c1^2);
b=2*(c1+D);
acal(jf,1)=(4*sqrt(b)*w^2*c2)/((2*w*c2)^2+b^2);
% ...dadc1;
denom1=4*D^3*sqrt(c1+D);
G(jblock,1)=(-sqrt(2)*w^2*c2*(D+2*c1))/denom1;
% ...dadc2;
denom1=4*((c1+D)^(5/2)*D^3);
G(jblock,2)=sqrt(2)*w^2*(-w^4*c2^4+w^2*c2^2*c1^2-w^2*c2^2*c1*D+4*D*c1^3+4*c1^4)/denom1;
% ...delta data;
deldata(jblock,1)=alpha(jf)-acal(jf);
end;
% -----------end AMPL frequency loop 
% ...balance units due to different data types
bsum=0;
asum=0;
for jf=1:nfb
bsum=bsum+abs(c(jf));    
end;
bsum=bsum/nfb;
for jf=1:nfa
jf2=jf+nfb;
asum=asum+abs(alpha(jf));
end;
asum=asum/nfa;
bpoint=bsum/asum;
% ...error bar relative weighting of rows  
for jw=1:length(erb)
if weight==2  wtb(jw)=1/erb(jw); end;
if weight==1  wtb(jw)=1/stdvb(jw); end;
if weight==0  wtb(jw)=1; end;
end;  % next jw
factorb=max(wtb);
wtb=wtb/factorb;

for jw=1:length(era)
if weight==2  wta(jw)=1/era(jw); end;
if weight==1  wta(jw)=1/stdva(jw); end;
if weight==0  wta(jw)=1; end;
end;  % next jw
factora=max(wta);
wta=wta/factora;

% ...balance weighting 
%       Phase Velocity Dispersion
for j=1:nfb
wt(j)=wtb(j)*(balance/bpoint);
end;
%       Amplitude Decay
for k=1:nfa
j=k+nfb;
wt(j)=wta(k)*(1-balance);
end;
m=nfb+nfa;
W=eye(m,m);
for jb=1:m
W(jb,jb)=W(jb,jb)*wt(jb);
end;
% ...column weighting (parameters)
Y=eye(2,2);
Y(1,1)=1/max(G(:,1));
Y(2,2)=1/max(G(:,2));
% ...inversion step
WGY=W*G*Y;
H=Y*inv((WGY)'*WGY+dwm)*(WGY)'*W;
dm=H*deldata;
c1old=c1;
c2old=c2;
c1=c1+dm(1);
c2=c2+dm(2);
% ...positive constraint;
c1=abs(c1);
c2=abs(c2);
% ...fit error;
Lsq=sqrt(deldata'*deldata);
svitr(iter)=iter;
svlsq(iter)=Lsq;
svlsqw(iter)=sqrt((W*deldata)'*(W*deldata));
% ...chi-squared;
svchib(iter)=(deldata(1:nfb)'*deldata(1:nfb))/((nfb-2)*merb);
svchia(iter)=(deldata(nfb+1:nfb+nfa)'*deldata(nfb+1:nfb+nfa))/((nfa-2)*mera);
% ..plot intermediate results;
xmax=max(fb);
ymax1(1)=max(c);
ymax1(2)=max(ccal);
ymax=max(ymax1);
xmin=0;
ymin=0;
clf;
frect=[xmin,xmax,ymin,ymax];
subplot(2,1,1);
plot(fb,ccal,'-r');
axis(frect);
grid on;
hold on;
plot(fb,c,'o');
errorbar(fb,c,stdvb,stdvb,'o');
svlsqtxt=sprintf('%1.3e',svlsqw(iter));
c1txt=sprintf('%8.0f',c1old);
c2txt=sprintf('%8.0f',c2old);
T1=sprintf('Velocity: LSQE=%s    C1=%s     C2=%s ',svlsqtxt,c1txt,c2txt);
title(T1);
% 
ymax1(1)=max(alpha);
ymax1(2)=max(acal);
ymax=max(ymax1);
frect=[xmin,xmax,ymin,ymax];
subplot(2,1,2)
plot(fa,acal,'-r');
axis(frect);
grid on
hold on
plot(fa,alpha,'o');
errorbar(fa,alpha,stdva,stdva,'o');
T2=sprintf('Attenuation  Balance=%.2f  Weighting=%s',balance,Wtxt);
title(T2);
xlabel('Frequency (Hz)');
pause(1);

end
% -----------end iteration loop

% Create Data Covariance Matrix, Cd using errors from bvas.his
nf=nfa+nfb;
cdd=eye(nf,nf);
for j=1:nfb
  cdd(j,j)=cdd(j,j)*erb(j);
end
for j=1:nfa
  jj=j+nfb;
  cdd(jj,jj)=cdd(jj,jj)*era(j);
end

%...compute Cm (the covariance matrix of the parameters c1 and c2
cm=(H*cdd)*H';
deltac1=sqrt(cm(1,1));
deltac2=sqrt(cm(2,2));

svlsqtxt=sprintf('%1.3e',svlsqw(iter));
c1txt=sprintf('%8.0f',c1old);
c2txt=sprintf('%8.0f',c2old);
sigc1txt=sprintf('%.1f',deltac1);
sigc2txt=sprintf('%.1f',deltac2);


T3=sprintf('Velocity: LSQE=%s C1=%s (+/- %s) C2=%s (+/- %s)',...
svlsqtxt,c1txt,sigc1txt,c2txt,sigc2txt);
%-----------------------------------------------------------
% -----------------------while loop start-----------------------------
%close;  %close figure(1)
isw1=1;
while isw1==1

nc=questdlg('Continue LSQE Plot ?','Choose','Yes','No','Yes');
switch nc
   case {'Yes'}
   isw3=1;
   case {'No'}
   isw3=0;
end %endswitch
if isw3 == 1
% plot error vs iteration
xmin=1; xmax=length(svitr);
ymin=0; ymax=max(svlsqw);
figure(2)
frect=[xmin,ymin,xmax,ymax];
plot(svitr,svlsqw,'-r')
grid on
title('Weighted Square Error vs Iteration Number')
xlabel('Iteration');
ylabel('LSQE');
drawnow
end  %endif isw3 

nc=questdlg('Continue Chi^2 Plot ?','Choose','Yes','No','Yes');
switch nc
   case {'Yes'}
   isw3=1;
   case {'No'}
   isw3=0;
end %endswitch
if isw3 == 1
% plot chi-square vs iteration
xmin=1; xmax=length(svitr);
ymin=0; ymax=max(svchib);
figure(3)
subplot(2,1,1)
frect=[xmin,xmax,ymin,ymax];
plot(svitr,svchib,'-r')
grid on
title('Chi-Squared Phase Velocity')
xlabel('Iteration');

% plot chi-square vs iteration
xmin=1; xmax=length(svitr);
ymin=0; ymax=max(svchia);
subplot(2,1,2)
frect=[xmin,xmax,ymin,ymax];
plot(svitr,svchia,'-r')
grid on
title('Chi-Squared Attenuation')
drawnow
end  %endif isw3

nc=questdlg('Save Results to disk ?','Choose','Yes','No','Yes');
switch nc
   case {'Yes'}
   isw3=1;
   case {'No'}
   isw3=0;
end %endswitch
if isw3 == 1
% save to disk DECAY
disp('writing decay: caouta.dat to disk .  .  .');
fp2=fopen('caouta.dat','w');
for k=1:nfa
fprintf(fp2,'%16.8E %16.8E %16.8E %16.8E \n',...
fa(k),alpha(k),stdva(k),acal(k));
end
for k=1:length(fax)
fprintf(fp2,'%16.8E %16.8E %16.8E %16.8E \n',...
fax(k),alphax(k),stdvax(k),acalx(k));
end
fclose(fp2);

% save to disk VELOCITY
disp('writing velocity: caoutc.dat to disk .  .  .');
fp2=fopen('caoutc.dat','w');
for k=1:nfb
fprintf(fp2,'%16.8E %16.8E %16.8E %16.8E \n',...
fb(k),c(k),stdvb(k),ccal(k));
end
for k=1:length(fbx)
fprintf(fp2,'%16.8E %16.8E %16.8E %16.8E \n',...
fbx(k),cx(k),stdvbx(k),ccalx(k));
end
fclose(fp2);

% save to disk SOLUTION and +/- uncertainty
disp('writing solution: casol.dat to disk .  .  .');
fp2=fopen('casol.dat','w');
fprintf(fp2,'%16.8E ',...
c1old,c2old,deltac1,deltac2,damp,mera,merb,weight,balance);
fprintf(fp2,' \n');
fclose(fp2);

% save to disk LSQE 
disp('writing LSQE: calsqe.dat to disk .  .  .');
fp2=fopen('calsqe.dat','w');
for k=1:length(svitr)
fprintf(fp2,'%16.8E %16.8E %16.8E \n',svitr(k),svlsqw(k),svlsq(k));
end
fclose(fp2);

% save to disk  DELTA DATA, WEIGHTED DELTA DATA
disp('writing delta data: cadeld.dat to disk .  .  .');
fp2=fopen('cadeld.dat','w');
wdeld=W*deldata;
for k=1:length(wdeld)
fprintf(fp2,'%16.8E %16.8E \n',wdeld(k),deldata(k));
end
fclose(fp2);

% save to disk CHI-SQUARED 
disp('writing Chi^2: cachi2.dat to disk .  .  .');
fp2=fopen('cachi2.dat','w');
for k=1:length(svitr)
fprintf(fp2,'%16.8E %16.8E %16.8E \n',svitr(k),svchib(k),svchia(k));
end
fclose(fp2);
end %endif isw3
isw1=0;  % break out of loop
end;   % endwhile

[rt,sigmart]=relaxtime(c1,deltac1,c2,deltac2)
RT=sprintf(' Relaxation Time=%.2f msec. (+/- %.2f msec)',rt*1000,sigmart*1000)
msgbox(RT);




