%   |------------------------------------------------------------|
%   | $Id: caplot3.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $          |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: caplot3                                     |
%   | DIRECTORY: BSUROOT/Octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose: plot the solution for stiffness and damping       |
%   |          (joint inversion done by cainv3.m)                |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
sw1=exist('caoutc.dat', 'file');
if sw1==0
disp('-----------------------------------------');
disp('==>ABORT: cainv3.m must have been run first');
disp('-----------------------------------------');
fflush(stdout);
exit
end
%Function Definitions
function [rt,sigmart]=relaxtime(c1,sigma1,c2,sigma2)
% compute relaxation time, sigma's are 1 stdev
rt=c2/c1;
sigmart=sqrt( ((c2/(c1*c1))*sigma1)^2 + ((1.0/c1)*sigma2)^2);
end

% load results from cainv3.m run
caouta=load('-ascii','caouta.dat'); % fa, alpha, stdva, acal (decay)
stdvap=caouta(:,3);
stdvam=caouta(:,3);
caoutc=load('-ascii','caoutc.dat'); % fb, c,     stdvb, ccal (velocity)
stdvbp=caoutc(:,3);
stdvbm=caoutc(:,3);
casol=load('-ascii','casol.dat');  % c1, c2, deltac1, deltac2,
				   %  damp, mera, merb,weight,balance 
c1=casol(:,1); c2=casol(:,2);
weight=casol(:,8); balance=casol(:,9);
deltac1=casol(:,3); deltac2=casol(:,4);
calsqe=load('-ascii','calsqe.dat');  % svitr, svlsqw, svlsq 
cadeld=load('-ascii','cadeld.dat');  % wdeld, deldata  (data residuals) 
cachi2=load('-ascii','cachi2.dat');  % svitr, svchib, svchia (chi-2) 
[rt,sigmart]=relaxtime(c1,deltac1,c2,deltac2); % Relaxation Time

% scalar for 95% confidence
conf=1.96;

% ---write some text labels
c1txt=sprintf(' C1=%.0f (+/-)%.0f',c1,conf*deltac1);
c2txt=sprintf('  C2=%.0f (+/-)%.0f',c2,conf*deltac2);
RTtxt=sprintf('  RelaxTime=%f (+/-)%f sec.',rt,conf*sigmart);
if conf==1.96  conftxt=sprintf(' 95%% Conf.');end;
if weight==0  wtxt=sprintf(' No error weighting'); end;
if weight==1  wtxt=sprintf(' 1/Stdv error weighting'); end;
if weight==2  wtxt=sprintf(' 1/Var  error weighting'); end;
btxt=sprintf(' Balance=%1.2f',balance);

%set grid 
nc=questdlg('Show Grid on Plots?','Choose','Yes','No','Yes');
switch  nc
   case{'Yes'}
   gdon=1;
   case{'No'}
   gdon=0;
end %endswitch

% find excluded data after fit segment of data
nptsc=length(caoutc(:,1));
nfit=0;
for jfind=1:nptsc
if caoutc(jfind,4) > 0.0
nfit=nfit+1;
end;
end;  %next jfind

figure(1)
isw1=1;
while isw1==1 
% ---phase velocity plot
plot(caoutc(:,1),caoutc(:,2),'o');    % measured velocity
plot(caoutc(1:nfit,1),caoutc(1:nfit,4),'-r');     % calculated velocity
errorbar(caoutc(:,1),caoutc(:,2),conf*caoutc(:,3),conf*caoutc(:,3))
title('Velocity');


xmin=0;                   %set defaults
xmax=max(caoutc(:,1));
ymin=0;
ymax=max(caoutc(:,2));
ymax=ceil(ymax/100)*100;

%edit axes 
prompt = {'Min. Freq. Hz','Min. Velocity','Max. Freq. Hz','Max. Velocity'};
dlg_title ='Edit Axes Limits';
num_lines =1;
defaultans ={num2str(xmin),num2str(ymin),num2str(xmax),num2str(ymax)};
cn=inputdlg(prompt,dlg_title,num_lines,defaultans);
frect=str2double(cn);
xmin=frect(1); ymin=frect(2); xmax=frect(3); ymax=frect(4);

nc=questdlg('Plot Range?','Range','FIT ONLY','ALL','ALL');
switch  nc
   case{'FIT ONLY'}
   prng=1;
   case{'ALL'}
   prng=0;
end %endswitch

%find subscript bounds for xmin and xmax
if prng==1
[dmy,jmin]=min(abs(caoutc(1:nfit,1)-xmin));
[dmy,jmax]=min(abs(caoutc(1:nfit,1)-xmax));
else
jmin=1;
jmax=nptsc;
end
%define subwindow
frect=[xmin,xmax,ymin,ymax];
plot(caoutc(jmin:jmax,1),caoutc(jmin:jmax,2),'o');    % measured velocity
hold on
plot(caoutc(1:nfit,1),caoutc(1:nfit,4),'-r');     % calculated velocity
axis(frect);

%clip error bars outside of plot window (avoid xfig problem)
for jf=1:length(stdvbp)
if conf*stdvbp(jf)+caoutc(jf,2)>ymax  
stdvbp(jf)=(ymax-caoutc(jf,2))/conf; end;
if caoutc(jf,2)-conf*stdvbm(jf)<ymin  
stdvbm(jf)=(caoutc(jf,2)-ymin)/conf; end;
end;  %next jf
errorbar(caoutc(jmin:jmax,1),caoutc(jmin:jmax,2),conf*stdvbm(jmin:jmax),conf*stdvbp(jmin:jmax))
% Label the plot
%label x-axis
xlabel(' Frequency (Hz)');
%label y-axis
ylabel('Velocity (m/s)');
T1=sprintf('Velocity %s %s \n %s %s %s',c1txt,c2txt,conftxt,wtxt,btxt);
title(T1);
if gdon==1
grid on; end;
drawnow


nc=questdlg('Go to Attenuation Plot?','Continue','Yes','No','Yes');
switch  nc
   case{'Yes'}
   isw1=1;
   case{'No'}
   isw1=0;
   exit;
end %endswitch

figure(2)
if isw1==1 
%---attenuation plot
plot(caouta(:,1),caouta(:,2),style=-3);    % measured atten 
plot(caouta(1:nfit,1),caouta(1:nfit,4),2,frameflag=0,axesflag=0); % calculated atten
errorbar(caouta(:,1),caouta(:,2),conf*caouta(:,3),conf*caouta(:,3))
title('Attenuation');

xmin=0;                   %set defaults
xmax=max(caouta(:,1));
ymin=0;
ymax=max(caouta(:,2));

%edit axes 
prompt = {'Min. Freq. Hz','Min. Atten.','Max. Freq. Hz','Max. Atten.'};
dlg_title ='Edit Axes Limits';
num_lines =1;
defaultans ={num2str(xmin),num2str(ymin),num2str(xmax),num2str(ymax)};
cn=inputdlg(prompt,dlg_title,num_lines,defaultans);
frect=str2double(cn);
xmin=frect(1); ymin=frect(2); xmax=frect(3); ymax=frect(4);

% find subscript bounds for xmin and xmax
if prng==1
[dmy,jmin]=min(abs(caouta(1:nfit,1)-xmin));
[dmy,jmax]=min(abs(caouta(1:nfit,1)-xmax));
else
jmin=1;
jmax=nptsc;
end

frect=[xmin,xmax,ymin,ymax];

clf
plot(caouta(jmin:jmax,1),caouta(jmin:jmax,2),'o');    % measured attenuation
hold on;
plot(caouta(1:nfit,1),caouta(1:nfit,4),'-r');     % calculated attenuation
%clip error bars outside of plot window (avoid xfig problem)
for jf=1:length(stdvap)
if conf*stdvap(jf)+caouta(jf,2)>ymax 
stdvap(jf)=(ymax-caouta(jf,2))/conf; end;
if caouta(jf,2)-conf*stdvam(jf)<ymin 
stdvam(jf)=(caouta(jf,2)-ymin)/conf; end;
end;  %next jf
errorbar(caouta(jmin:jmax,1),caouta(jmin:jmax,2),conf*stdvam(jmin:jmax),conf*stdvap(jmin:jmax))
if gdon==1 
grid on; end;
axis(frect);

% Label the plot
%label x-axis
xlabel(' Frequency (Hz)');
%label y-axis
ylabel('Attenuation (1/m)');
T2=sprintf('Attenuation %s',RTtxt);
title(T2)
end;   %endif attenuation plot
drawnow

nc=questdlg('Go to Chi^2 Plot?','Continue','Yes','No','Yes');
switch  nc
   case{'Yes'}
   isw1=1;
   case{'No'}
   isw1=0;
   exit;
end %endswitch

if isw1==1 
figure(3);
%---chi-2 plot
xmin=0;                   %set defaults
xmax=max(cachi2(:,1));
ymin=0.1; 
ymax=max(max(cachi2(:,2)),max(cachi2(:,3)));
%setup plot frame limits
yframe=[ymin;ymax]; xframe=[xmin;xmax];

semilogy(xframe,yframe,'+')
hold on;
semilogy(cachi2(:,1),cachi2(:,2),'-b');           % velocity 
semilogy(cachi2(:,1),cachi2(:,3),'-r');     % attenuation 
title('Chi^2 Velocity and Attenuation');
if gdon==1 
grid on; end;
hold off
drawnow

%edit axes 
prompt = {'Min. Iteration','Chi^2 Min.','Max. Iteration','Chi^2 Max.'};
dlg_title ='Edit Axes Limits';
num_lines =1;
defaultans ={num2str(xmin),num2str(ymin),num2str(xmax),num2str(ymax)};
cn=inputdlg(prompt,dlg_title,num_lines,defaultans);
frect=str2double(cn);
xmin=frect(1); ymin=frect(2); xmax=frect(3); ymax=frect(4);


%setup plot frame limits
yframe=[ymin;ymax]; xframe=[xmin;xmax];

frect=[xmin,xmax,ymin,ymax];

semilogy(xframe,yframe,'+');
if gdon==1 
grid on; end;
hold on
semilogy(cachi2(:,1),cachi2(:,2),'-b');  % velocity 
semilogy(cachi2(:,1),cachi2(:,3),'-r');     % attenuation 

% Label the plot
%label x-axis
xlabel(' Iteration Number');
T4=sprintf('Chi^2 Velocity and Attenuation %s %s \n %s %s %s',...
c1txt,c2txt,conftxt,wtxt,btxt);
title(T4);

mera=casol(:,6);
merb=casol(:,7);
stdvcm=sqrt(merb);
stdvam=sqrt(mera);
stdvctxt=sprintf('  Velocity (+/-)%.0f',conf*stdvcm);
stdvatxt=sprintf('  Attenuation (+/-)%.2f',conf*stdvam);
text(cachi2(1,1),cachi2(1,2),stdvctxt)
text(cachi2(1,1),cachi2(1,3),stdvatxt)

isw1=0;
end;   %endif chi2 plot











isw1=0;
end %temp while
