%   |------------------------------------------------------------|
%   | $Id: direct.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $           |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: direct.m                                    |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose: to compute direct arrival, V1 solution from bref  |
%   |   (normal refraction shooting, common shot gathers)        |
%   |Typical Flow: (pic first breaks, insert to headers)         |
%   | file.seg --> segpic.m -->pics.txt --| bpic                 |
%   |                                     |-->bpic-->bpicfile.seg|
%   |                          file.seg --|                      |
%   |                                                            |
%   | bpicfile.seg -->bref ---> G001 |                           |
%   |                      |--> D001 |-->direct.m --> overburden |
%   |                      |--> E001 |                velocity   |
%   |                                                & plot      |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
%fflush(stdout)
prompt = {'System Matrix File','Data Vector File','Elevations File'};
dlg_title = 'Enter bref files ';
num_lines = 1;
defaultans = {'G001','D001','E001'};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
%frect = str2double(cn);
Gfile=cn{1,1}; Dfile=cn{2,1}; Efile=cn{3,1};

% read data
G=load('-ascii',Gfile);
D=load('-ascii',Dfile);
E=load('-ascii',Efile);

% assign variables
d=D(:,1);
flag=D(:,2);
elv=E(:,3);
chan=E(:,1);
recv=E(:,2);
[N,M]=size(G);

prompt = {'Number of Shots'};
dlg_title ='Enter Parameter';
num_lines =1;
defaultans ={num2str(1)};
cn=inputdlg(prompt,dlg_title,num_lines,defaultans);
frect=str2double(cn);
nshot=frect(1);  
nchanl=M-nshot-1;

% Compute Inverse
GG=G(:,M);
H=inv(GG'*GG)*GG';

% solution slowness of overburden layer
m=H*d;

% velocity of layer
v1=1/m;
v1txt=sprintf('%d',ceil(v1));

% plot fit to times
dcal=GG*m;  %calculated times
err=d-dcal;
rms=sqrt((err'*err)/N);
rmstxt=sprintf("%f",rms);

% break into shot efforts
jg=1;
k=0;
itogl=1;
for j=1:N
if G(j,jg)==1 
k=k+1;
dplot(k,itogl)=d(j);
dcalplt(k,itogl)=dcal(j);
flagplt(k,itogl)=flag(j);
else
jg=jg+1;
itogl=itogl+1;
k=0;
end
end

% loop over shots
jmx=size(flagplt,2);
for j=1:jmx
test=max(flagplt(:,j));
 if test>0
 flg=flagplt(:,j);
 kmx=length(flg);
 kk=0;
   for k=1:kmx
     if dplot(k,j)>0
     kk=kk+1;
     doplt(kk)=dplot(k,j);
     fplt(kk)=flg(k);
     dcplt(kk)=dcalplt(k,j);
     end % endif
   end % next k
kmx=kk;
 plot(fplt(1:kmx),doplt(1:kmx)*1000,'+')
hold on
 plot(fplt(1:kmx),dcplt(1:kmx)*1000,'-r')
 end % endif
end % next j
% compute velocity error bar
sigm2=inv(GG'*GG)*rms*rms;
sigv2=(1/(m*m))^2*sigm2;
sigv=sqrt(sigv2);
sigvtxt=sprintf('%.0f m/s',sigv);
grid on
T=sprintf('Direct Wave: V1= %s (+/-) %s',v1txt,sigvtxt);
title(T)
xlabel('STATION')
ylabel('Arrival Time (msec)');
tmax=max(max(doplt),max(dcplt))*1000;
xmax=max(flag);
xmin=min(flag);
axis([xmin,xmax,0,tmax]);
%print('plot.ps','-dpsc2');
