%   |------------------------------------------------------------|
%   | $Id: fqKVMBscan.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $   |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: fqKVMBscan.m                                |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   |2DOF System (water and frame) simulated by                  |
%   | Scan for different damping values                          |
%   |18 August 2005 Made Kd units m/s throughout                 |
%   |  Plots:  Frequency (Hz) vs. KV damping ratio               |
%   | damping ratio=c/(2*sqrt(k*m))                              |
%   |   Based on original Scilab Code                            |
%   |   soil-norm-fscan-eig.sci        2DOF->1DOF mapping        |
%   |                                                            |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|

clear

%frequency values 
FN(1)=.1;
for j=2:70
FN(j)=FN(j-1)*1.2;
end %next j
npts=length(FN);

isw1=1;
icase=0;
Gs=2.67;     %specific gravity of solid
rhow=1000;  %water mass density
rhof=rhow*Gs; %frame mass density
Ah=1;  %cross-section area 
vs=200; %shear wave velocity (doesn't matter, L adjusted)
no=0.3  %reference porosity for Gf, L computation

Gf=vs*vs*(rhof*(1-no));  %shear modulus frame

while isw1==1 ,
icase=icase+1;

%get arguments
prompt = {'Kd (m/s)','n (porosity)'};
dlg_title = 'Enter Parameters';
num_lines = 1;
defaultans = {'.01','.25'};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
Kd=frect(1); n=frect(2);


for kk=1:npts
omegan=FN(kk)*pi*2;
L=sqrt(Gf/((omegan^2)*(1-n)*Gs*rhow));  %length of sample
kf=(Gf*Ah)/L; %spring stiffness
e=n/(1-n);  %void ratio
mw=n*Ah*L*rhow;  %mass of water
mf=Ah*L*(1-n)*Gs*rhow; %mass of frame
m1f=mf+mw;  %total mass
            % df=dashpot kg/s
df=(n*n*9.81*rhow*Ah*L)/Kd; %dashpot value for this case of scan
biot=df/(Ah*L);

%eigenvalues 2DOF System
A=[ 0, 1, 0;
  -kf/mf, -df/mf, +df/mf;
  0,  +df/mw , -df/mw];

%[V, delta]=eig(A);
delta=eig(A); 

%find real eigenvalue, discard
%imaginary parts
ip(1)=imag(delta(1));
ip(2)=imag(delta(2));
ip(3)=imag(delta(3));
%real parts
rp(1)=real(delta(1));
rp(2)=real(delta(2));
rp(3)=real(delta(3));
j1=1;
for j=1:3
if (abs(ip(j))>1.E-3) 
ev(j1)=rp(j)+i*ip(j);
j1=j1+1;
end  %endif
end % next j

%equivalent dashpot and spring
sk(kk)=(real((ev(1)*ev(2))))*mf;  %equivalent spring
sc(kk)=(-real((ev(1)+ev(2))))*mf; %equivalent dashpot
svfo(kk)=sqrt(sk(kk)/mf)/(pi*2);  %equivalent natural frequency hz
nsc(kk)=sc(kk)/(2*sqrt(sk(kk)*mf));  %normalize to damping ratio
%fixed 16Aug05 damping ratio
end  %next kk

if icase==1 
mtxt=sprintf('n=%.2f Kd=%.4f',n,Kd);
  loglog(FN,nsc)
  axis([0.1,10000,1E-6,1.0]);
  title('Equivalent KV Damping Ratio');
  xlabel('Frequency Hz');
  ylabel('Damping Ratio KV');
  hold on
  grid on
  grid minor off
  drawnow
msgbox('click on label location');
[xp,yp]=ginput(1);
text(xp,yp,mtxt);
else
mtxt=sprintf('n=%.2f Kd=%.4f',n,Kd);
  loglog(FN,nsc)
  drawnow
msgbox('click on label location');
[xp,yp]=ginput(1);
text(xp,yp,mtxt);
end
%Do an another ?
nc=questdlg('Continue?','Next Case','Yes','No','Yes');
switch nc
   case{'Yes'}
    isw1=1;
   case{'No'}
    isw1=0;
end
end %endwhile isw1

