%   |------------------------------------------------------------|
%   | $Id: hodo2plot.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $        |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: hodo2plot.m                                 |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose: read a BSEGY file and plot hodogram               |
%   |     This program assumes different components              |
%   |     are in DIFFERENT FILES.                                |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
%fflush(stdout);
fileh=input('enter x-axis file name ','s');
filev=input('enter y-axis file name ','s');
fp1=fopen(fileh,'r');
fp2=fopen(filev,'r');

%read *.seg file info:  ntraces=number of traces
%                       npts=number samples per trace
%                       fsamin=sample interval in seconds
[nbytes,ntraces,npts,fsamin]=segyinfo(fp1);
[nbytes2,ntraces2,npts2,fsamin2]=segyinfo(fp2);

err=0;
if (npts!=npts2) 
err=1;
end
if (fsamin!=fsamin2)
err=1;
end
if (ntraces!=ntraces2)
err=1;
end
isw1=1;
while(isw1)
%read trace number jtrace by call to bsegin
%        data=vector of digitized samples
%        frange=source receiver separation
%        pic=first arrival time pick if any
%        rx,ry,rz=geophone coordinates
%        sx,sy,sz=source coordinates
%        sd=source depth, below sz
xstrE=sprintf('%s','ABORT: Inconsistent data \n');
xstr1=sprintf('%s %d traces tmax=%.3f sec. dt=%.5f \n',...
fileh,ntraces,(npts-1)*fsamin,fsamin);
xstr2=sprintf('%s %d traces tmax=%.3f sec. dt=%.5f ',...
filev,ntraces2,(npts2-1)*fsamin2,fsamin2);
if err == 0
xstrE=sprintf('%s','GOOD: File Parameters Match \n');
xstr=strcat(xstrE,xstr1,xstr2)
msgbox(xstr);
else
xstr=strcat(xstrE,xstr1,xstr2)
msgbox(xstr);
break
end

%initialize data storrage
dh=zeros(ntraces,npts);
dv=zeros(ntraces,npts);
fr=zeros(ntraces,1);

prompt = {'Trace Number To Plot'};
dlg_title = 'Enter Trace';
num_lines = 1;
defaultans = {num2str(ntraces)};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
jrec=frect(1);  

% Read data from two files
[dh,frh,pich,rxh,ryh,rzh,sxh,syh,szh,sdh]=bsegin(fp1,npts,jrec);
[dv,frv,picv,rxv,ryv,rzv,sxv,syv,szv,sdv]=bsegin(fp2,npts,jrec);
fclose(fp1);
fclose(fp2);

%rescale signals to mvolts from microvolts
dh=dh./1000;
dv=dv./1000;
big=max([abs(dh)',abs(dv)']);
bigtxt=sprintf('%.3e',big);

prompt = {'Scale Factor To Use'};
dlg_title = 'Enter Parameter';
num_lines = 1;
defaultans = {bigtxt};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
bigg=frect(1); 
figure(1)
clf
axis([-1,1,-1,1]);
hold on

tmin=0;
tmax=(npts-1)*fsamin;

while (1)
% dialog for sample time
tmintxt=sprintf('%.3f',tmin);
tmaxtxt=sprintf('%.3f',tmax);

prompt = {'Tmin','Tmax'};
dlg_title = 'Enter Plot Range';
num_lines = 1;
defaultans = {tmintxt,tmaxtxt};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
tmin=frect(1); tmax=frect(2); 
% check for bozo choices
tmintxt=sprintf('%.3f',tmin);
tmaxtxt=sprintf('%.3f',tmax);
jmin=tmin/fsamin + 1;
jmax=tmax/fsamin +1;
if jmax>npts 
 jmax=npts;
 end;
if jmin<1  
 jmin=1;
 end;

% select data
clear x; clear y;
x=dh(jmin:jmax)/bigg;
y=dv(jmin:jmax)/bigg;
nxy=length(x);

% plot hodogram
bigtxt=sprintf('%.2e',bigg);
frtxt=sprintf('%4.3f',frv);

T1=strcat('Offset=',frtxt,' m  Scale Factor: ',bigtxt,' mv');
title(T1);
xlbl=sprintf('%s',fileh);
ylbl=sprintf('%s',filev);
xlabel(xlbl);
ylabel(ylbl);
plot(x(1),y(1),'o')
   tlabl=sprintf('%.1f',tmin*1000);
   text(x(1),y(1),tlabl);
plot([0,0],[-1,1],'-r')
plot([-1,1],[0,0],'-r')
plot(x(nxy),y(nxy),'o')
tlabl=sprintf('%.1f ms',tmax*1000);
text(x(nxy),y(nxy),tlabl);
plot(x(1:nxy),y(1:nxy),'-b');
grid
axis('square');
drawnow;
tmin=tmax;
tmax=(npts-1)*fsamin;
escp=questdlg('Done or Continue?','Escape','Done','Cont','Cont');
if escp == 'Done'
break
end
grid
end; % endwhile

isw1=0;
end; % endwhile isw1























