%   |------------------------------------------------------------|
%   | $Id: hodoplot.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $         |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: hodoplot.m                                  |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose: read a BSEGY file and plot hodogram               |
%   |     This program assumes different components in same file |
%   |                                                            |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
%fflush(stdout);
filen=input('enter file name ','s');
fp1=fopen(filen,'r');

%read *.seg file info:  ntraces=number of traces
%                       npts=number samples per trace
%                       fsamin=sample interval in seconds
[nbytes,ntraces,npts,fsamin]=segyinfo(fp1);

%read trace number jtrace by call to bsegin
%        data=vector of digitized samples
%        frange=source receiver separation
%        pic=first arrival time pick if any
%        rx,ry,rz=geophone coordinates
%        sx,sy,sz=source coordinates
%        sd=source depth, below sz
xstr=sprintf('%d traces tmax=%.3f sec. dt=%.5f',ntraces,(npts-1)*fsamin,fsamin);
msgbox(xstr);

%initialize data storrage
d=zeros(ntraces,npts);
fr=zeros(ntraces,1);

% store data in memory
for k=1:ntraces
[data,frange,pic,rx,ry,rz,sx,sy,sz,sd]=bsegin(fp1,npts,k);
d(k,:)=data;
fr(k)=frange;
rxsv(k)=rx;
rysv(k)=ry;
rzsv(k)=rz;
sxsv(k)=sx;
sysv(k)=sy;
szsv(k)=sz-sd; %sz=elev shot, sd=depth shot sz-sd=elev charge
end;  %next k
fclose(fp1);

%choose traces to plot
phone=questdlg('Choose Down Hole or Reference Phone','Select Phone',...
'Down','Refr','Down');
% X-Axis
if phone == 'Down'
xpltchk=questdlg('Enter X-axis','Choose Signal','vertical',...
'radial','transverse','radial');
switch xpltchk
   case {'vertical'}
   xplt=1; xlbl='Vertical';
   case {'radial'}
   xplt=2; xlbl='Radial';
   case {'transverse'}
   xplt=3; xlbl='Transverse';
   otherwise
   xplt=2; xlbl='Radial';
end
else
xpltchk=questdlg('Enter X-axis','Choose Signal','vertical',...
'radial','transverse','radial');
switch xpltchk
   case {'vertical'}
   xplt=4; xlbl='Ref. Vertical';
   case {'radial'}
   xplt=5; xlbl='Ref. Radial';
   case {'transverse'}
   xplt=6; xlbl='Ref. Transverse';
   otherwise
   xplt=5; xlbl='Ref. Radial';
end
end
% Y-Axis
if phone == 'Down'
ypltchk=questdlg('Enter Y-axis','Choose Signal','vertical',...
'radial','transverse','transverse');
switch ypltchk
   case {'vertical'}
   yplt=1; ylbl='Vertical';
   case {'radial'}
   yplt=2; ylbl='Radial';
   case {'transverse'}
   yplt=3; ylbl='Transverse';
   otherwise
   yplt=2; ylbl='Radial';
end
else
ypltchk=questdlg('Enter Y-axis','Choose Signal','vertical',...
'radial','transverse','transverse');
switch ypltchk
   case {'vertical'}
   yplt=4; ylbl='Ref. Vertical';
   case {'radial'}
   yplt=5; ylbl='Ref. Radial';
   case {'transverse'}
   yplt=6; ylbl='Ref. Transverse';
   otherwise
   yplt=5; ylbl='Ref. Radial';
end
end

%rescale signals to mvolts from microvolts
d=d./1000;
big=max([abs(d(xplt,:)),abs(d(yplt,:))]);
bigtxt=sprintf('%.3e',big);

prompt = {'Scale Factor To Use'};
dlg_title = 'Enter Parameter';
num_lines = 1;
defaultans = {bigtxt};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
bigg=frect(1); 
figure(1)
clf
axis([-1,1,-1,1]);
hold on

tmin=0;
tmax=(npts-1)*fsamin;

while (1)
% dialog for sample time
tmintxt=sprintf('%.3f',tmin);
tmaxtxt=sprintf('%.3f',tmax);

prompt = {'Tmin','Tmax'};
dlg_title = 'Enter Plot Range';
num_lines = 1;
defaultans = {tmintxt,tmaxtxt};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
tmin=frect(1); tmax=frect(2); 
% check for bozo choices
tmintxt=sprintf('%.3f',tmin);
tmaxtxt=sprintf('%.3f',tmax);
jmin=tmin/fsamin + 1;
jmax=tmax/fsamin +1;
if jmax>npts 
 jmax=npts;
 end;
if jmin<1  
 jmin=1;
 end;

% select data
clear x; clear y;
x=d(xplt,jmin:jmax)/big;
y=d(yplt,jmin:jmax)/big;
nxy=length(x);

% plot hodogram
bigtxt=sprintf('%.2e',big);
frtxt=sprintf('%4.3f',fr(xplt));
tstxt=sprintf('\n Shot (%.2f,%.2f,%.2f) \n',sxsv(xplt),sysv(xplt),szsv(xplt));
trtxt=sprintf(' Rec. (%.2f,%.2f,%.2f) \n',rxsv(xplt),rysv(xplt),rzsv(xplt));

loclbl=strcat(tstxt,trtxt);
T1=strcat(filen,' Offset=',frtxt,loclbl,'Scale Factor: ',bigtxt,' millivolts');
title(T1)
plot(x(1),y(1),'o')
   tlabl=sprintf('%.1f',tmin*1000);
   text(x(1),y(1),tlabl);
plot([0,0],[-1,1],'-r')
plot([-1,1],[0,0],'-r')
plot(x(nxy),y(nxy),'o')
tlabl=sprintf('%.1f ms',tmax*1000);
text(x(nxy),y(nxy),tlabl);
plot(x(1:nxy),y(1:nxy),'-b');
grid
axis('square');
xlabel(xlbl)
ylabel(ylbl)
drawnow;
tmin=tmax;
tmax=(npts-1)*fsamin;
escp=questdlg('Done or Continue?','Escape','Done','Cont','Cont');
if escp == 'Done'
break
end
grid
end; % endwhile

























