%   |------------------------------------------------------------|
%   | $Id: kvKVMBscan.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $   |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: kdKVMBscan.m                                |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   |2DOF System (water and frame) simulated by                  |
%   | Scan for different damping values                          |
%   | Plots:  KV  vs. KVMB damping ratios                        |
%   | damping ratio=c/(2*sqrt(k*m))                              |
%   |   Based on original Scilab Code                            |
%   |   basic-scan-eig.sci       Basic 2DOF->1DOF mapping        |
%   |                                                            |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|

clear

%damping values as fraction of spring
Rk(1)=.0000001;
for j=2:105
Rk(j)=Rk(j-1)*1.2;
end %next j

%50hz omega
mw=100; %mass water
mf=1000; %mass frame
fn=50; %natural frequency Hz

isw1=1;
icase=0;
while isw1==1 
icase=icase+1;

fntxt=sprintf('%.0f',fn);

%get arguments
prompt = {'water mass Mw','frame mass Mf'};
dlg_title = 'Enter Parameters';
num_lines = 1;
defaultans = {'100','1000'};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
mw=frect(1); mf=frect(2); 
kf=mf*(fn*2*pi)^2; %spring frame

m1f=mf+mw;  %total mass



for kk=1:length(Rk)
               %solve for Kd, darcy hydraulic conductivity
               %that corresponds to this df=dashpot kg/s
df=Rk(kk)*kf; %dashpot value for this case of scan
dfsv(kk)=df; %save dashpot kg/s

%eigenvalues 2DOF System
A=[ 0, 1, 0;
  -kf/mf, -df/mf, +df/mf;
  0,  +df/mw , -df/mw];

%[V, delta]=eig(A);
delta=eig(A); 

%find real eigenvalue, discard
%imaginary parts
ip(1)=imag(delta(1));
ip(2)=imag(delta(2));
ip(3)=imag(delta(3));
%real parts
rp(1)=real(delta(1));
rp(2)=real(delta(2));
rp(3)=real(delta(3));
j1=1;
for j=1:3
if (abs(ip(j))>1.E-3) 
ev(j1)=rp(j)+i*ip(j);
j1=j1+1;
end  %endif
end % next j

%format(20)

%equivalent dashpot and spring
sk(kk)=(real((ev(1)*ev(2))))*mf;  %equivalent spring
sc(kk)=(-real((ev(1)+ev(2))))*mf; %equivalent dashpot
svfo(kk)=sqrt(sk(kk)/mf)/(pi*2);  %equivalent natural frequency hz
nsc(kk)=abs(real(ev(1)+ev(2)))/(2*sqrt(real(ev(1)*ev(2)))); % compute damping ratio KV
end  %next kk

%normalize to damping ratio
ndfsv=dfsv./(2*sqrt(kf*mf));  %fixed 16Aug05
% nsc=sc./(2*sqrt(sk*mf));


if icase==1 
mratio=mf/mw; %mass ratio, frame to water
mtxt=sprintf('Mf/Mw=%.0f',mratio);
loglog(ndfsv,nsc)
axis([1.E-5,1.E3,1E-5,1.0])
title('Equivalent KV Damping Ratio');
xlabel('Damping Ratio KVMB');
ylabel('Damping Ratio KV');
grid on
grid minor off
msgbox('click on label location');
[xp,yp]=ginput(1);
text(xp,yp,mtxt);
hold on
else
mratio=mf/mw; %mass ratio, frame to water
mtxt=sprintf('Mf/Mw=%.0f',mratio);
hold on
loglog(ndfsv,nsc)
drawnow
msgbox('click on label location');
[xp,yp]=ginput(1);
text(xp,yp,mtxt);
end
%Do an another ?
nc=questdlg('Continue?','Next Case','Yes','No','Yes');
switch nc
   case{'Yes'}
    isw1=1;
   case{'No'}
    isw1=0;
end
end %endwhile isw1
