%   |------------------------------------------------------------|
%   | $Id: mastercurve.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $      |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: mastercurve.m                               |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | Invert rayleigh wave given bvax results                    |
%   | uses SVD inverse, set p=number of singular values          |
%   |                                                            |
%   |Starting model: model.txt is a file with 3 rows             |
%   |Example: for nlay=3 vi=shear velocity, zi=depth layer top   |
%   | nlay                                                       |
%   | v1 v2 v3                                                   |
%   | z1 z2 z3                                                   |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http:% www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  Note: requires disper.oct (run build_disper_oct to build) |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|

clear
igo=1;
while (igo)
c=exist('disper.oct');
 if c == 0
 c2=exist('build_disper_oct');
 c3=exist('wrapper.cpp');
 c4=exist('rwv.f');
   if c2 != 0 && c3 != 0 && c4 !=0
   T=sprintf('Requires disper.oct \nTo run build_disper_oct, CLICK OK');
   msgbox(T);
   system('build_disper_oct');
 else
   T1=sprintf('ABORT\n');
   if c2 ==0 T2=sprintf('build_disper_oct missing\n'); else T2=' '; end
   if c3 ==0 T3=sprintf('wrapper.cpp missing\n'); else T3=' '; end
   if c4 ==0 T4=sprintf('rwv.f missing'); else T4=' '; end 
   T=strcat(T1,T2,T3,T4);
   msgbox(T);
break
end
end

nlay=3;
zi=[0; 1.0; 1.001];
Alpha=[800; 800; 2500]; % P-wave velocities
Beta=[100; 100; 200];  % shear velocities
rho=[1600; 1600; 1800]; % density
deltz=1;
maxmode=9;
% frq=input('enter frequency Hz')
fmax=99;
fmin=1;
df=1;
Nfreq=(fmax-fmin)/df+1;
frect=[.1,.9,.9,10];
figure(1)
clf;

% start loop jcase
for jcase=2:5
Beta(3)=Beta(1)*jcase;
for j=1:length(zi)
mu(1,j)=rho(j)*Beta(j)^2; % shear modulus
lame(1,j)=rho(j)*(Alpha(j)^2-2.00*Beta(j)^2); % Lame's constant
end

for j=1:Nfreq
Freq(j)=fmin+(j-1)*df;
zstart=zi(2);
frq=Freq(j);
pv=zeros(maxmode,1);

[pv]=disper(nlay,rho,mu,lame,zi,deltz,frq,maxmode,pv);

c(j)=pv(1);  % just save the fundamental mode
end

b21(jcase)=Beta(3)/Beta(1);

% normalize frequency
for j=1:Nfreq
Freqn(j)=Freq(j)*(zi(2)/Beta(1));
end
% normalize phase velocity
for j=1:Nfreq
cn(j)=c(j)/Beta(1);
end
loglog(Freqn,cn);
T=sprintf('B2/B1=%d',b21(jcase));
text(.02,b21(jcase),T);
drawnow
hold on
end %  next jcase
%xtitle('Normalized Rayleigh Wave Phase Velocity','Frequency F*H/B1','C/B1');
grid on
axis([.01,1,.9,10])
title('Master Curve Fundamental Mode Dispersion');
xlabel('Normalized Frequency F*(H/B1)');
ylabel('Normalized Velocity C/B1');

igo=0;
end %endwhile
