%   |------------------------------------------------------------|
%   | $Id: moho.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $             |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: moho.m                                      |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   |Fowrward problem, Rayleigh wave dispersion surface to moho. |
%   |   Sample program illustrating how to use rwv.f             |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  Note: requires disper.oct (run build_disper_oct to build) |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|

clear
igo=1;
while (igo)
c=exist('disper.oct');
 if c == 0
 c2=exist('build_disper_oct');
 c3=exist('wrapper.cpp');
 c4=exist('rwv.f');
   if c2 != 0 && c3 != 0 && c4 !=0
   T=sprintf('Requires disper.oct \nTo run build_disper_oct, CLICK OK');
   msgbox(T);
   system('build_disper_oct');
 else
   T1=sprintf('ABORT\n');
   if c2 ==0 T2=sprintf('build_disper_oct missing\n'); else T2=' '; end
   if c3 ==0 T3=sprintf('wrapper.cpp missing\n'); else T3=' '; end
   if c4 ==0 T4=sprintf('rwv.f missing'); else T4=' '; end 
   T=strcat(T1,T2,T3,T4);
   msgbox(T);
break
end
end
nlay=3;
zi=[0; 35000; 35001];
Beta=[3500; 3500; 4500];  % shear velocities
Alpha=Beta*sqrt(3);	% P-velocities
rho=[2700; 2700; 3300]; % density
for j=1:length(zi)
mu(1,j)=rho(j)*Beta(j)^2; % shear modulus
lame(1,j)=rho(j)*(Alpha(j)^2-2.00*Beta(j)^2); % Lame's constant
end
deltz=35000;
maxmod=1;
% frq=input('enter frequency Hz')
Pmax=60;   
Pmin=1; 
dP=1;
Nfreq=(Pmax-Pmin)/dP+1;
for j=1:Nfreq
Period(j)=Pmax-(j-1)*dP;
zstart=zi(2);
frq=1/Period(j);
pv=zeros(9,1);

[pv]=disper(nlay,rho,mu,lame,zi,deltz,frq,maxmod,pv);

c(j)=pv(1);  % just save the fundamental mode
end
 
figure(1)
clf;
plot(Period,c,'-b');
grid on
title('Fundamental Mode Dispersion Crustal Model');
xlabel('Period (Hz)');
ylabel('Velocity (m/s)');
drawnow
igo=0;
end %endwhile
