%   |------------------------------------------------------------|
%   | $Id: profplot.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $       |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: profplot.m                                  |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose: plot seismic traces from a file in bsegy format   |
%   |                                                            |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
fflush(stdout)
filen=input('enter file name ','s');
fp1=fopen(filen,'r');

%read *.seg file info:  ntraces=number of traces
%                       npts=number samples per trace
%                       fsamin=sample interval in seconds
[nbytes,ntraces,npts,fsamin]=segyinfo(fp1);

%read trace number jtrace by call to bsegin
%        data=vector of digitized samples
%        frange=source receiver separation
%        pic=first arrival time pick if any
%        rx,ry,rz=geophone coordinates
%        sx,sy,sz=source coordinates
%        sd=source depth, below sz
fsamintxt=sprintf(' dt=%.5f sec',fsamin);
xstr=sprintf('%d traces tmax=%.3f sec. dt=%.4f',ntraces,npts*fsamin,fsamin);
disp(fsamintxt)
disp(xstr)
clf
%compute time vector for plot

tm=1:npts;
tm=tm*fsamin;

for jtrace=1:ntraces
[data,frange,pic,rx,ry,rz,sx,sy,sz,sd]=bsegin(fp1,npts,jtrace);
sfac=max(data);
plot(tm,(data./sfac)-1.0*(jtrace-1))
hold on
end
xlabel('Time (s)');
title(xstr)
hold off
fclose(fp1);
grid

