%   |------------------------------------------------------------|
%   | $Id: rayleigh.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $         |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: rayleigh.m                                  |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   |Fowrward problem, Rayleigh wave dispersion example.         |
%   |   Sample program illustrating how to use rwv.f             |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  Note: requires disper.oct (run build_disper_oct to build) |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
igo=1;
while (igo)
c=exist('disper.oct');
 if c == 0
 c2=exist('build_disper_oct');
 c3=exist('wrapper.cpp');
 c4=exist('rwv.f');
   if c2 != 0 && c3 != 0 && c4 !=0
   T=sprintf('Requires disper.oct \nTo run build_disper_oct, CLICK OK');
   msgbox(T);
   system('build_disper_oct');
 else
   T1=sprintf('ABORT\n');
   if c2 ==0 T2=sprintf('build_disper_oct missing\n'); else T2=' '; end
   if c3 ==0 T3=sprintf('wrapper.cpp missing\n'); else T3=' '; end
   if c4 ==0 T4=sprintf('rwv.f missing'); else T4=' '; end 
   T=strcat(T1,T2,T3,T4);
   msgbox(T);
break
end
end

nlay=4;
zi=[0; 1.21; 13.04; 30.0];
Alpha=[1700; 1700; 1700; 1700]; % P-wave velocities
Beta=[219; 83; 213; 300];  % shear velocities
rho=[2169; 2169; 2169; 2169]; % density
for j=1:length(zi)
mu(j,1)=rho(j)*Beta(j)^2; % shear modulus
lame(j,1)=rho(j)*(Alpha(j)^2-2.00*Beta(j)^2); % Lame's constant
end
deltz=1;
maxmod=9;
% frq=input('enter frequency Hz')
fmax=50;
fmin=1;
df=1;
Nfreq=(fmax-fmin)/df+1;
for j=1:Nfreq
Freq(j)=fmin+(j-1)*df;
zstart=zi(2);
frq=Freq(j);
pv=zeros(maxmod,1);

[pv]=disper(nlay,rho,mu,lame,zi,deltz,frq,maxmod,pv);

c(j)=pv(1);  % just save the fundamental mode
c2(j)=pv(2);
end
 for j=length(c2):-1:1
   if c2(j)>0.0
   jstart=j;
   end
 end

clf;
plot(Freq,c,'b',Freq(jstart:Nfreq),c2(jstart:Nfreq),'r');
grid;
title('Fundamental and next higher mode dispersion');
xlabel('Frequency (Hz)');
ylabel('Velocity (m/s)');
igo=0;
end %endwhile
