%   |------------------------------------------------------------|
%   | $Id: refplot.m,v 1.2 2020/05/06 19:29:47 pm Exp $          |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: refplot.m                                   |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose: read a BSEGY file and plot REFRACTION first       |
%   |          break picks, fit linear trend, get slope->velocity|
%   |                                                            |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
%fflush(stdout)
pkg load statistics
filen=input('enter file name ','s');
fp1=fopen(filen,'r');

%read *.seg file info:  ntraces=number of traces
%                       npts=number samples per trace
%                       fsamin=sample interval in seconds
[nbytes,ntraces,npts,fsamin]=segyinfo(fp1);

%read trace number jtrace by call to bsegin
%        data=vector of digitized samples
%        frange=source receiver separation
%        pic=first arrival time pick if any
%        rx,ry,rz=geophone coordinates
%        sx,sy,sz=source coordinates
%        sd=source depth, below sz
xstr=sprintf('  %s \n %d traces tmax=%.3f sec. dt=%.4f \n Mouse used to label fits',...
             filen,ntraces,npts*fsamin,fsamin);
msgbox(xstr);
%compute time vector for plot

j=1;
kk=0;
for k=1:ntraces
[data,frange,pic,rx,ry,rz,sx,sy,sz,sd,sp,vp]=bsegin(fp1,npts,k);
  if (pic ~= 0.) 
  kk=kk+1;
  svpic(kk,1)=pic;   % first arrival pick in seconds
  svrx(kk,1)=rx;     % receiver inline X-coordinate
  svsx(kk,1)=sx;     % shot inline X-coordinate
  rxx(kk,1)=frange;  % source receiver offset
  svvp(kk,1)=vp;     % geophone station number
  end
end %next k
fclose(fp1);

xaxislabl=questdlg('Choose X-Axis For Plot','Select X-Axis ',...
'Stations','Offset  ','Stations');
if xaxislabl == 'Stations'
iswx=0;
else
iswx=1;
end

%plot pics
if iswx == 0
plot(svvp,svpic*1000.,'+')
xlabel('Station Number')
ylabel('Arrival Time (ms)')
else
plot(rxx,svpic*1000.,'+')
xlabel('Offset (m)')
ylabel('Arrival Time (ms)')
end
T=sprintf('File: %s  Shot Point: %d',filen,sp);
title(T)
hold on
grid
drawnow

% loop linear fit segments
gocont=1
icnt=0;
while (gocont)
gocont=questdlg('Pick A Segment?','Continue','Yes','No ','Yes')
  if gocont == 'No '
  break;
  else
icnt=icnt+1;
[x,y]=ginput(2)

% set min and max
zmin=min(x);
zmax=max(x);
   if zmin>zmax 
   tmp1=zmin;
   zmin=zmax;
   zmax=tmp1;
   end;  %endif

clear xx;
clear xxx;
clear yy;
clear yycal;

% find min and max indexes
nchnl=length(rxx);
clear jindex;
jjc=1;

if iswx==1
  for j=1:nchnl
  if (rxx(j)>=zmin && rxx(j)<=zmax) 
    jindex(jjc)=j;
    jjc=jjc+1;
    end; %endif
  end; %next j
else
  for j=1:nchnl
  if (svvp(j)>=zmin && svvp(j)<=zmax) 
    jindex(jjc)=j;
    jjc=jjc+1;
    end; %endif
  end; %next j
end %endif
 
jmin=min(jindex);
jmax=max(jindex);
  if jmin<1
  jmin=1;
  end;
  if jmax>nchnl 
  jmax=nchnl;
  end;

%...load interval into yy
k=1;
for j=jmin:jmax
yy(k,1)=svpic(j);
xx(k,1)=rxx(j);
xxx(k,1)=svvp(j);
k=k+1;
end

%...compute internal sums needed for velocity st.dev.
nptf=length(yy);
sumx=0;
sumy=0;
sumxy=0;
sumx2=0;
for j=1:nptf
sumx=sumx+xx(j);
sumy=sumy+yy(j);
sumxy=sumxy+xx(j)*yy(j);
sumx2=sumx2+xx(j)^2;
end
summ=0;
for j=1:nptf
summ=summ+(sumx-nptf*xx(j))^2;
end

%linear regression OLS Inverse
G=[ones(size(xx)),xx];
H=inv(G'*G)*G';
m=H*yy;
c0=m(1);  % intercept time
c1=m(2);  % slowness of refractor  1/Vref
vf(icnt)=abs(1/c1);
To(icnt)=(c0)*1000;

% compute calculated data
for k=1:nptf
yycal(k,1)=xx(k)*c1+c0;
end

% compute time standard deviation (for error bar)
e=yy-yycal;
sum1=e'*e;
if iswx == 1
plot(xx,yycal*1000,'-r')
else
plot(xxx,yycal*1000,'-r')
end

% tinv(X,DF) student T
conf=95;  %Confidence Limit 95%=.95
Q=(1-conf/100)/2;
P=1-Q;
DF=nptf-2; 
talpha=tinv(P,DF);

% solution appraisal
% sigd=.0002^2;   %estimate of sdtv pick times
sigd=(2*fsamin)^2; % set to 2 samples for good data
%sigd=sum1/(nptf-2); % estimate from sum square error

Cd=eye(nptf,nptf)*sigd;  %covariance matrix, data
Cm=H*Cd*H';   %covariance matrix, parameters
sigto=sqrt(Cm(1,1))*1000;
sigslow=sqrt(Cm(2,2));
vtop=1/(c1-sigslow);
vbot=1/(c1+sigslow);
sigmav=(vtop-vbot)/2;

%apply Student-T to est. of variance
sigmav=sigmav*talpha;
sigto=sigto*talpha;

msg2=sprintf('%4.0f (+/-%3.0f) m/s \n',vf(icnt),sigmav);
msg1=sprintf('To=%3.1f (+/-%3.1f) ms',To(icnt),sigto);
[a,b]=ginput(1);
text(a,b,[msg2,msg1]);
drawnow

% Display Chi-Square Value
chisq=sum1/((nptf-2)*sigd);
chisqtxt=sprintf('Chi-Square=%4.2f',chisq);
msgbox(chisqtxt);
  end %endif
end % endwhile
print('plot.ps','-dpsc2');
print('plot.fig','-dfig');
