%   |------------------------------------------------------------|
%   | $Id: saswv.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $        |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: vplot                                       |
%   | REQUIRES: segyinfo.m and bsegin.m                          |
%   | DIRECTORY: BSUROOT/Octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose:  SASW Analysis from vibrator and T-rex.           |
%   | saswv.m directly reads Cross Power Spectrm data.           |
%   |                                                            |
%   | This  differs from program SASW.m which reads two          |
%   | time domain signals from a multple trace record            |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http:% www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
%fflush(stdout);
% Example data included for testing: dx32f.txt
filen=input('Enter file name. ex dx32f.txt ','s');
%filen='dx32f.txt';
% Data File Format
% record 1:  dx=32 means receivers separated by 32 feet.
% record 2: Stations for receivers R1, R2, and Shot S, Source type
% record 3: comment
% record 4: labels of columns that follow
% f=frequency Hz | Gxy=Cross Power Spectrum volts| Gxy Phase (deg), Coherence
%record 5:  blank
% records 6---EOF data in columns defined above
%==========================================================================
% Credits: Dr. Soheil Nazarian, Dr. Dennis Hiltunen, Dr. Glen Rix         |
% SASW Benchmarking symposium, Geophysical Engineering Committe of ASCE GI|
% National Geotechnical Experimentation Site(NGES), Texas A&M             | 
% Site 61                                                                 |
% REF: GeoRisk 2011 / ISBN 9780784411834 GSP 224 ASCE                     |
%==========================================================================
fp1=fopen(filen,'r');
hd=fgets(fp1);
eval(hd);
hd=fgets(fp1);
i1=strfind(hd,'R2');
eval(hd(1:i1-1));
i2=strfind(hd,'S');
eval(hd(i1:i2-1));
i3=strfind(hd,'T'); %only good for T-Rex source
eval(hd(i2:i3-1));
for j=3:5
hd=fgets(fp1)
end
 [data,count,err]=fscanf(fp1,'%f ');
fclose(fp1);
nrows=length(data)/4;
k=1;
for j=1:4:nrows
frq(k,1)=data(j);
GxyVolts(k,1)=data(j+1);
GxyPhase(k,1)=data(j+2);
cohrnc(k,1)=data(j+3);
k=k+1;
end

figure(1)
clf
T=sprintf('Units=feet:  dX=%.0f   R1=%.0f   R2=%.0f   S=%.0f ',dX,R1,R2,S);
subplot(311)
plot(frq,GxyVolts*1000,'-b');
grid on
title(T);
ylabel('Amplitude (mv)')
subplot(312)
plot(frq,GxyPhase,'-r');
grid on
ylabel('Phase (deg)')
grid on
subplot(313)
plot(frq,cohrnc,'-k')
ylabel('Coherence')
grid on
xlabel('Frequency (Hz)')
drawnow

% compute phase velocity
fmin=6;
fmax=46;
npts=length(frq)
prompt = {'Fmin (Hz)','Fmax (Hz)'};
dlg_title = 'Enter Parameter';
num_lines = 1;
defaultans = {num2str(fmin),num2str(fmax)};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
fmin=frect(1); fmax=frect(2);
df=frq(2)-frq(1);
fshift=frq(1);
j1=(fmin-fshift)/df+1;
j2=(fmax-fshift)/df + 1;
if j1<1 
j1=1;
end
if j2>length(frq)
j2=length(frq);
 end

%unwrap phase
Phz=GxyPhase;
jwarp=0;
for j=j1+1:j2
tmp1=GxyPhase(j-1);
tmp2=GxyPhase(j);
dphz=tmp2-tmp1;
  if dphz > 180 
   jwarp=jwarp-360 ;
   Phz(j)=GxyPhase(j)+jwarp;
  else
   Phz(j)=GxyPhase(j)+jwarp;
  end
end

dx=dX*.3048;  % convert to meters
for j=2:npts
T=1/frq(j);
dT=T*(Phz(j)/360);
cvel(j)=abs(dx/dT); % meters/sec
end

figure(2)
clf
subplot(211)
plot(frq(j1:j2),cvel(j1:j2),'-b')
T=sprintf('Phase Velocity \n Units=feet:  dX=%.0f   R1=%.0f   R2=%.0f   S=%.0f ',dX,R1,R2,S)
title(T)
ylabel('Velocity (m/s)')
grid on
subplot(212)
plot(frq(j1:j2),cohrnc(j1:j2),'-k')
title('Coherence');
xlabel('Frequency (Hz)')
ylabel('unitless')
grid on

