%   |------------------------------------------------------------|
%   | $Id: segpic.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $           |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: segpic.m                                    |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose: plot seismic traces from a file in bsegy format   |
%   |          and pick times with a mouse.                      |
%   |                                                            |
%   | Naming: ex. input file=twav.seg ofile=twav.pic             |
%   | Insert Pics to Headers using bpic                          |
%   | ex.     bpic twav.seg 1 twav.pic 0.                        |
%   |         bpictwav.seg = filename with pics in header        |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
%fflush(stdout)
filen=input('enter file name ','s');
oname=filen(1: findstr(filen,'.')-1);
ofile=strcat(oname,'.pic')
fp1=fopen(filen,'r');

%read *.seg file info:  ntraces=number of traces
%                       npts=number samples per trace
%                       fsamin=sample interval in seconds
[nbytes,ntraces,npts,fsamin]=segyinfo(fp1);

%read trace number jtrace by call to bsegin
%        data=vector of digitized samples
%        frange=source receiver separation
%        pic=first arrival time pick if any
%        rx,ry,rz=geophone coordinates
%        sx,sy,sz=source coordinates
%        sd=source depth, below sz
fsamintxt=sprintf(' dt=%.5f sec',fsamin);
xstr=sprintf('%d traces tmax=%.3f sec. dt=%.5f sec',ntraces,npts*fsamin,fsamin);
msgbox(xstr);

prompt = {'Clip Factor','Tmax'};
dlg_title = 'Clip Factor 1=No Clip ';
num_lines = 1;
defaultans = {num2str(3.0),num2str((npts-1)*fsamin)};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
clipf=frect(1); tmax=frect(2);

%maximum sample number to plot
jmax=tmax/fsamin+1;
if jmax > npts ;
jmax=npts;
end;

%time vector
for j=1:npts;
tm(j)=(j-1)*fsamin;
end;

savepics=zeros(ntraces,1);

figure(1)
clf

title(xstr)

for jtrace=1:ntraces
[data,frange,pic,rx,ry,rz,sx,sy,sz,sd]=bsegin(fp1,npts,jtrace);
ymax=max(abs(data(1:jmax)))/clipf;
plot(tm(1:jmax),data(1:jmax),'-b')
axis([0.0,tmax,-ymax,+ymax]);
grid 
xlabel('Time (s)');
T=sprintf('Trace Number %d',jtrace);
title(T);
[xpic,ypic]=ginput(1);
savepics(jtrace)=xpic;
end
fclose(fp1);

%write out pics to a file
fp1=fopen(ofile,'w');
for j=1:ntraces
fprintf(fp1,'%d  %.8f \n',j,savepics(j));
end
fclose(fp1);

