function [nbytes,ntraces,npts,fsamin]=segyinfo(fp1)
%   |------------------------------------------------------------|
%   | $Id: segyinfo.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $     |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: Octave / MATLAB                                  |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: segyinfo.m                                  |
%   | DIRECTORY: BSUROOT/Octave                                  |
%   |------------------------------------------------------------|
%   | purpose: read a BSEGY file and extract number of samples   |
%   |          number of traces, and sample interval.            |
%   |          assumes that the file has been opened             |
%   |          in calling program:  fp1=fopen(filename,'r')      |
%   |------------------------------------------------------------|
%   | Octave is an interpreter useful for scientifc calculations.|
%   |It is similar to MATLAB and Octave files often run in MATLAB|
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|

%compute file size in bytes
fseek(fp1,0,'eof');
nbytes=ftell(fp1);

%move current position to byte 115
fseek(fp1,114,'bof');

%read number of samples
npts=fread(fp1,1,'int16','ieee-le');

%read sample interval in microseconds
samin=fread(fp1,1,'int16','ieee-le');  %short integer
fsamin=samin/1.E6;

%compute number of traces
nbptr=240+npts*4;
ntraces=nbytes/nbptr;

%move pointer to begining of file
fseek(fp1,0,'bof');
end
