%   |------------------------------------------------------------|
%   | $Id: traplt.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $       |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: traplt.m                                    |
%   | DIRECTORY: BSUROOT/octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose: plot seismic trace  from a file in bsegy format   |
%   |                                                            |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
%fflush(stdout);
filen=input('enter file name ','s');
fp1=fopen(filen,'r');

%read *.seg file info:  ntraces=number of traces
%                       npts=number samples per trace
%                       fsamin=sample interval in seconds
[nbytes,ntraces,npts,fsamin]=segyinfo(fp1);

%read trace number jtrace by call to bsegin
%        data=vector of digitized samples
%        frange=source receiver separation
%        pic=first arrival time pick if any
%        rx,ry,rz=geophone coordinates
%        sx,sy,sz=source coordinates
%        sd=source depth, below sz
fsamintxt=sprintf(' dt=%.5f sec',fsamin);
xstr=sprintf('%d traces tmax=%.3f sec. dt=%.5f',ntraces,(npts-1)*fsamin,fsamin);
disp(fsamintxt)
disp(xstr)

tmax=(npts-1)*fsamin;
tmaxtxt=sprintf('%.4f',tmax);
jtrace=ntraces;
jtracetxt=sprintf('%d',jtrace);

%get arguments
prompt = {'Tmax','Trace Number'};
dlg_title = 'Enter Parameters';
num_lines = 1;
defaultans = {tmaxtxt,jtracetxt};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
tmax=frect(1); jtrace=frect(2);


%maximum sample number to plot
jmax=tmax/fsamin+1;
if jmax > npts 
jmax=npts;
end;

%compute time vector for plot
for j=1:npts;
tm(j)=(j-1)*fsamin;
end;


[data,frange,pic,rx,ry,rz,sx,sy,sz,sd,sp,vp,geoazi,geover]=bsegin(fp1,npts,jtrace);
sfac=max(data);
fclose(fp1);

%plot data
figure(1);
clf;
plot(tm(1:jmax),data(1:jmax))
xlabel('Time (s)');
xstr=sprintf('Trace %d tmax=%.3f sec. dt=%.5f',jtrace,(npts-1)*fsamin,fsamin);
title(xstr)
grid

msgbox('Pick time zero phase reference with mouse');
[tzero,ydumy]=ginput(1);

%get time zero for phase
prompt = {'Max Frequency Hz'};
dlg_title = 'Enter Plot Max Frequency';
num_lines = 1;
ndt=npts*fsamin;
defaultans = {num2str((npts/2)/ndt)};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
fmax=frect(1);

%compute spectrum
z=fft(data);
ndt=npts*fsamin;
frq=0:npts-1;
frq=frq/ndt;
jmax=fmax*ndt;

%rotate phase for picked time zero
for j=1:npts
theta=-2*pi*tzero*frq(j);
z(j)=z(j)*exp(i*theta);
end
f=1:jmax;
f=f/(ndt);
figure(2)
clf
subplot(211)
plot(f,abs(z(1:jmax)),'-r')
xlabel('Frequency (Hz)');
ylabel('Amplitude');
grid on
subplot(212)
plot(f,unwrap(angle(z(1:jmax))),'-r');
ylabel('Unwrapped Phase Rad');
xlabel('Frequency (Hz)');
grid on

