%   |------------------------------------------------------------|
%   | $Id: vplot.m,v 1.1.1.1 2019/04/29 22:51:20 pm Exp $            |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: vplot                                       |
%   | REQUIRES: segyinfo.m and bsegin.m                          |
%   | DIRECTORY: BSUROOT/Octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose:  plot results from vfitw.m   procedure.           |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
disp('-----------------------------------------');
disp('==>NOTE: vfitw.m must have been run first');
disp('   suffix .vt and .vt2 will be added to next entry');
disp('-----------------------------------------');
%fflush(stdout);
filea=input('enter file name. ex twave.seg ','s');
filem=strcat(filea,'.vt');
filen=strcat(filea,'.vt2');
BB=load('-ascii',filem);
rz=BB(:,1);
tvert=BB(:,2);
fp2=fopen(filen,'r');
Title1=fgets(fp2);
isw2=fscanf(fp2,'%d',1);
frect=fscanf(fp2,'%e %e %e %e',4);
xmin=frect(1); ymin=frect(2); xmax=frect(3); ymax=frect(4);

%edit axes 
prompt = {'xmin','xmax','ymin','ymax'};
dlg_title ='Edit Axes Limits';
num_lines =1;
defaultans ={num2str(xmin),num2str(xmax),num2str(ymin),num2str(ymax)};
cn=inputdlg(prompt,dlg_title,num_lines,defaultans);
frect=str2double(cn);
xmin=frect(1); xmax=frect(2); ymin=frect(3); ymax=frect(4);

figure(1)
plot(tvert,rz,'o');
grid on
axis([xmin,xmax,ymin,ymax])
grid on
xlabel('Vertical Time (s)')
if isw2 ==1
ylabel('Feet');
else
ylabel('Meters');
end
title(Title1);

isw1=1;
ncount=0;

% start while loop
hold on
while isw1==1
drawnow
[xylabel,COUNT]=fscanf(fp2,'%e %e',2);
if COUNT == 2
xl=xylabel(1); yl=xylabel(2);
msg2=fscanf(fp2,'%s',2);
text(xl,yl,msg2);
npts=fscanf(fp2,'%d',1);
AA=fscanf(fp2,'%e',2*npts);
%demultiplex
j=1;
for k=1:2:npts*2
yy(j)=AA(k);
tcal(j)=AA(k+1);
j=j+1;
end
plot(tcal,yy,'-r')
clear AA; clear yy; clear tcal

else
isw1=0;
break;
end

end  % endwhile

fclose(fp2);
