     #include <octave/oct.h>
     #include <octave/f77-fcn.h>
     
     extern "C"
     {
       F77_RET_T
       F77_FUNC (rwv, FORTSUB)
             (const int&, double*, double*, double*, double*,
               double*, double*, const int& , double*  ); 
     }
     
     DEFUN_DLD (disper , args , , "Rayleigh Wave Solver")
     {
       octave_value_list retval;
       int nargin = args.length();
       if (nargin != 9)
         print_usage ();
       else
         {
           NDArray rho = args(1).array_value ();
           NDArray mu = args(2).array_value ();
           NDArray lame = args(3).array_value ();
           NDArray zi = args(4).array_value ();
           NDArray deltz = args(5).array_value ();
           NDArray frq = args(6).array_value ();
           NDArray maxmod = args(7).array_value ();
           NDArray pv = args(8).array_value ();
           if (! error_state)
             {
               double *rhov = rho.fortran_vec ();
               double *muv = mu.fortran_vec ();
               double *lamev = lame.fortran_vec ();
               double *ziv = zi.fortran_vec ();
               double *deltzv = deltz.fortran_vec ();
               octave_idx_type nlay = rho.numel ();
               octave_idx_type maxmodv = pv.numel ();
               double  *frqv = frq.fortran_vec ();
               double *pvv = pv.fortran_vec ();
     
               F77_XFCN (rwv, FORTSUB, (nlay, rhov, muv, lamev, ziv,
                   deltzv, frqv, maxmodv, pvv ));
     
               retval(0) = pv;
             }
         }
       return retval;
     }

