%   |------------------------------------------------------------|
%   | $Id: yulewalker.m,v 1.2 2020/05/02 16:01:05 pm Exp $       |
%   | Basic Seismic Utilities (BSU)                              |
%   | LANGUAGE: octave                                           |
%   | AUTHOR: P. MICHAELS                                        |
%   | FUNCTION NAME: YuleWalker                                  |
%   | REQUIRES: segyinfo.m and bsegin.m                          |
%   | DIRECTORY: BSUROOT/Octave                                  |
%   |  revised for OCTAVE                                        |
%   |------------------------------------------------------------|
%   | purpose: compute and plot yule-walker all pole spectra     |
%   | Note: If signal is already an autocorrelation, it should   |
%   |       be a 2 sided autocorrelation. Code will take 1/2     |
%   |------------------------------------------------------------|
%   | octave is an interpreter useful for scientifc calculations.|
%   | It is similar to MATLAB and may be obtained free from      |
%   | http://www.gnu.org/software/octave                         |
%   |------------------------------------------------------------|
%   |  NOTICE:                                                   |
%   |  Copyright (c) 2017 Paul Michaels                          |
%   |  <pm@cgiss.boisestate.edu>                                 |
%   |  This program is free software; you can                    |
%   |  redistribute it and/or modify it under the terms          |
%   |  of the GNU General Public License as published            |
%   |  by the Free Software Foundation; either version           |
%   |  3 of the License, or (at your option) any later           |
%   |  version.  This program is distributed in the              |
%   |  hope that it will be useful, but                          |
%   |  WITHOUT ANY WARRANTY; without even the implied            |
%   |  warranty of MERCHANTABILITY or FITNESS FOR A              |
%   |  PARTICULAR PURPOSE.  See the GNU General Public           |
%   |  License for more details.                                 |
%   |  You should have received a copy of the GNU                |
%   |  General Public License along with this program;           |
%   |  if not, write to the Free Software Foundation,            |
%   |  Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             |
%   |------------------------------------------------------------|
clear
%load octave-signal processing toolbox package
pkg load signal

%fflush(stdout)
filen=input('enter file name ','s');
isw1=questdlg('Input? Data or Autocorrelation','Select','Data','Auto','Data');
if isw1 == 'Auto'
isw1 = 'Auto';
end


fp1=fopen(filen,'r');
%read *.seg file info:  ntraces=number of traces
%                       npts=number samples per trace
%                       fsamin=sample interval in seconds
[nbytes,ntraces,npts,fsamin]=segyinfo(fp1);
%read trace number jtrace by call to bsegin
%        data=vector of digitized samples
%        frange=source receiver separation
%        pic=first arrival time pick if any
%        rx,ry,rz=geophone coordinates
%        sx,sy,sz=source coordinates
%        sd=source depth, below sz
fsamintxt=sprintf(' dt=%.5f sec',fsamin);
xstr=sprintf('%d traces tmax=%.3f sec. dt=%.5f sec',ntraces,npts*fsamin,fsamin);
msgbox(xstr);

% enter trace number to analyze
prompt = {'trace number'};
dlg_title = 'Enter Trace';
num_lines = 1;
defaultans = {num2str(ntraces)};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
jtrace=frect(1);

[data,frange,pic,rx,ry,rz,sx,sy,sz,sd]=bsegin(fp1,npts,jtrace);
fclose(fp1);

%compute time vector for plot
tm=0:length(data)-1;
tm=tm*fsamin;
figure(1);
clf;
plot(tm,data)
grid
drawnow();

%get arguments
if isw1 == 'Data'
prompt = {'Max. Time','Max. Frequency (Hz)'};
dlg_title = 'Enter Parameters';
num_lines = 1;
defaultans = {num2str(tm(npts)),num2str(200)};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
tmax=frect(1); fmax=frect(2);
else
prompt = {'Max. Frequency (Hz)'};
dlg_title = 'Enter Parameters';
num_lines = 1;
defaultans = {num2str(200)};
cn = inputdlg(prompt,dlg_title,num_lines,defaultans);
frect = str2double(cn);
tmax=tm(npts); fmax=frect(1);

end

%guard against dumb choices
nptsmx=tmax/fsamin;
if nptsmx > npts 
nptsmx=npts;
end %endif
% window signal
for k=1:nptsmx
s(1,k)=data(k);
end  %next k
if isw1 == 'Data'
smean=mean(s);
smeantxt=sprintf('signal mean=%f',smean);
dclevel=smean/max(abs(data))
msg1=sprintf('Remove DC %.1f percent ?',dclevel*100);
isw2=questdlg(msg1,'Select','Yes','No ','No ');
if isw2 == 'Yes'
% remove mean
s=s-smean;
end
end %end of Data test


%compute and pick autocorrelation
if (isw1 == 'Data')
  nt2=floor(length(s)/2);
  p2sided=xcorr(s,nt2);
  j1=floor(length(p2sided)/2+.5);
  j2=length(p2sided);
  ptotal=p2sided(j1:j2);
  xt2=(1:nt2+1)';
  figure(2)
  clf;
  plot(xt2,ptotal,'linewidth',2);
  grid
%  print 'auto.ps' -dps
  title('Pick max lag for autocorrelation with mouse')
  [a,b]=ginput(1);
  nlag=ceil(a);
%  delete(gcf); %delete current figure
  if nlag < 2 
   nlag=2;
  end %endif
  if nlag >nptsmx 
   nlag=nptsmx/2;
  end %endif
  fnyquist=1/(2*fsamin);
  if fmax >fnyquist 
  fmax=fnyquist;
  end  %endif
  if fmax < 0 
  fmax=1;
  end %endif
p=ptotal(1:nlag);
else
%input is autocorrelation
  [pmax,zerolag]=max(s);
  s2=s(zerolag:length(s));
  nt2=floor(length(s2/2));
  ptotal=s2(1:nt2);
  xt2=(1:nt2);
  figure(2);
  plot(xt2,ptotal,'linewidth',2);
  grid
%  print 'auto.ps' -dps
  title('Pick max lag for autocorrelation with mouse')
  [a,b]=ginput(1);
  nlag=ceil(a);
%  delete(gcf); %delete current figure
  if nlag < 2 
   nlag=2;
  end %endif
  if nlag >npts 
   nlag=npts/2;
  end %endif
  fnyquist=1/(2*fsamin);
  if fmax >fnyquist 
  fmax=fnyquist;
  end  %endif
  if fmax < 0 
  fmax=1;
  end %endif
p=ptotal(1:nlag);
end %endif

%solve levinson equ for order of process
clear ar; clear sigma2; 
%[ar,sigma2,rc]=lev(p(1:nlag)); 
[ar,sigma2]=levinson(p);

% set frequency array
nfmax=400;
df=fmax/nfmax;
frq=0:df:fmax;
omega=2*pi.*frq;

% z transform variable
z=exp(i.*omega*fsamin);
SS=polyval(ar,z);
S=sigma2./abs(SS);
%delete(gcf);
figure(3);
plot(frq,S,'linewidth',2)
grid
xlabel('Frequency Hz')
ylabel('Amplitude')
Ttl1=sprintf('Amplitude Spectrum: %s Order=%d Trace=%d',filen,nlag,jtrace);
title(Ttl1);
%print 'linplot.fig' -dfig -Fhelvetica:12 

figure(4)
dB=20*log10(S/max(S));
plot(frq,dB,'linewidth',2)
grid
xlabel('Frequency Hz')
ylabel('Decibels')
Ttl=sprintf('Spectrum (dB): %s Order=%d Trace=%d',filen,nlag,jtrace);
title(Ttl);
%print 'dBplot.fig' -dfig -Fhelvetica:12 


% Gnuplot Addition
smx=max(S);
S=S./smx;  %normalize
fp1=fopen('yw.dat','wt');
fprintf(fp1,'# %s \n',Ttl1);
for j=1:length(frq)
fprintf(fp1,'%E  %E  %E \n',frq(j),S(j),dB(j));
end
fclose(fp1);

tstamp=strftime('%Y.%j %H:%M:%S',localtime (time));
fp1=fopen('plotspec.gp','wt');
fprintf(fp1,'# Generated by yulewalker.m  \n');
fprintf(fp1,'# %s \n',Ttl1);
fprintf(fp1,'# Date: %s \n',tstamp);
fprintf(fp1,'                        \n')
fprintf(fp1,'set ytics 0, .2, 1.0    \n')
fprintf(fp1,'set mxtics \n')
fprintf(fp1,'set mytics \n')
fprintf(fp1,'set grid \n')
fprintf(fp1,'set xlabel "Frequency (Hz)"   \n')
fprintf(fp1,'set ylabel "Amplitude" \n')
fprintf(fp1,'set title " %s " \n',Ttl1)
fprintf(fp1,'set nokey               \n')
fprintf(fp1,'plot "yw.dat" u 1:2 w lines lw 2 lc 0 t "order=%d Trace=%d" \n',nlag,jtrace);
fprintf(fp1,'set terminal postscript size 5.0,4.0 inches font "Helvetica,10" \n')
fprintf(fp1,'set output "ywplot.ps"  \n')
fprintf(fp1,'replot   \n')
fprintf(fp1,'                        \n')
fclose(fp1);


